#include <bits/stdc++.h>
using namespace std;

string multiplyStringByInt(const string &num, int c) {
    if (c == 0) return "0";
    int carry = 0;
    string result;
    for (int i = (int)num.size() - 1; i >= 0; --i) {
        int digit = num[i] - '0';
        long long prod = 1LL * digit * c + carry;
        result.push_back(char('0' + (prod % 10)));
        carry = prod / 10;
    }
    while (carry > 0) {
        result.push_back(char('0' + (carry % 10)));
        carry /= 10;
    }
    reverse(result.begin(), result.end());
    return result;
}

string stripLeadingZeros(const string &s) {
    int i = 0;
    while (i < (int)s.size() - 1 && s[i] == '0') i++;
    return s.substr(i);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    string s, c_str;
    cin >> s >> c_str;
    int c = stoi(c_str);

    int n = s.size();
    for (int i = 1; i < n; i++) {
        string a_str = s.substr(i);     
        string b_str = s.substr(0, i); 

        string prod = multiplyStringByInt(a_str, c);

        if (stripLeadingZeros(prod) == stripLeadingZeros(b_str)) {
            cout << b_str << " " << a_str << "\n";
            break;
        }
    }
    return 0;
}