#include <iostream>
#include <vector>
#include <queue>
#include <cmath>
#include <climits>
#include <algorithm>

using namespace std;

typedef long long ll;

using State = pair<ll, pair<int, int>>;

bool is_blocked(ll p1, ll p2, int mask, int n, const vector<ll>& gate_pos) {
ll mn = min(p1, p2);
ll mx = max(p1, p2);

for (int i = 0; i < n; ++i) {

if (!(mask & (1 << i))) {

if (gate_pos[i] > mn && gate_pos[i] < mx) {
return true;
}
}
}
return false;
}


ll solve() {
int n;
ll kate_pos, hatch_pos;
cin >> n >> kate_pos >> hatch_pos;

vector<ll> key_pos(n);
vector<ll> gate_pos(n);
for (int i = 0; i < n; ++i) {
cin >> key_pos[i] >> gate_pos[i];
}

vector<vector<ll>> dist(n + 1, vector<ll>(1 << n, LLONG_MAX));


priority_queue<State, vector<State>, greater<State>> pq;

dist[0][0] = 0;
pq.push({0, {0, 0}});

while (!pq.empty()) {
auto [d, state] = pq.top();
auto [u_idx, u_mask] = state;
pq.pop();

if (d > dist[u_idx][u_mask]) {
continue;
}

ll u_pos = (u_idx == 0) ? kate_pos : key_pos[u_idx - 1];


for (int i = 0; i < n; ++i) {

if (!(u_mask & (1 << i))) {
int v_idx = i + 1;
ll v_pos = key_pos[i];
int v_mask = u_mask | (1 << i);

if (!is_blocked(u_pos, v_pos, u_mask, n, gate_pos)) {
ll new_dist = d + abs(v_pos - u_pos);


if (new_dist < dist[v_idx][v_mask]) {
dist[v_idx][v_mask] = new_dist;
pq.push({new_dist, {v_idx, v_mask}});
}
}
}
}
}

// --- Dijkstra is complete, now find the answer ---

// The final answer is the minimum cost to reach the hatch from *any* state.
ll min_cost = LLONG_MAX;

// 1. Check direct path from start (with 0 keys)
if (!is_blocked(kate_pos, hatch_pos, 0, n, gate_pos)) {
min_cost = abs(hatch_pos - kate_pos);
}

// 2. Check path from Kate's start *after* picking up keys
// (This checks states like start -> key A -> key B -> hatch)
for (int mask = 0; mask < (1 << n); ++mask) {
if (dist[0][mask] != LLONG_MAX) { // Should only be dist[0][0] but good to check
if (!is_blocked(kate_pos, hatch_pos, mask, n, gate_pos)) {
ll total_cost = dist[0][mask] + abs(hatch_pos - kate_pos);
min_cost = min(min_cost, total_cost);
}
}
}

// 3. Check path from every key location state
// (This checks states like start -> key A -> key B -> key C -> hatch)
for (int i = 0; i < n; ++i) { // For each key location
int loc_idx = i + 1;
ll pos = key_pos[i];

for (int mask = 0; mask < (1 << n); ++mask) {
// If this state (at key 'i' with 'mask') is reachable
if (dist[loc_idx][mask] != LLONG_MAX) {
// Check if the final path from here to the hatch is clear
if (!is_blocked(pos, hatch_pos, mask, n, gate_pos)) {
ll total_cost = dist[loc_idx][mask] + abs(hatch_pos - pos);
min_cost = min(min_cost, total_cost);
}
}
}
}

if (min_cost == LLONG_MAX) {
return -1; // No path found
} else {
return min_cost;
}
}

int main() {
// Fast I/O
ios_base::sync_with_stdio(false);
cin.tie(NULL);

int t;
cin >> t;
while (t--) {
cout << solve() << "\n";
}
return 0;
}
