#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
using State = pair<ll, pair<int, int>>;

ll solve() {
    int n;
    ll kate_pos, hatch_pos;
    cin >> n >> kate_pos >> hatch_pos;

    vector<ll> key_pos(n);
    vector<ll> gate_pos(n);
    vector<ll> all_pos(n + 1);
    all_pos[0] = kate_pos;

    for (int i = 0; i < n; ++i) {
        cin >> key_pos[i] >> gate_pos[i];
        all_pos[i + 1] = key_pos[i];
    }

    vector<vector<int>> blockers(n + 1, vector<int>(n + 1, 0));
    for (int i = 0; i <= n; ++i) {
        for (int j = 0; j <= n; ++j) {
            if (i == j) continue;
            ll mn = min(all_pos[i], all_pos[j]);
            ll mx = max(all_pos[i], all_pos[j]);
            int mask = 0;
            for (int k = 0; k < n; ++k) {
                if (gate_pos[k] > mn && gate_pos[k] < mx) {
                    mask |= (1 << k);
                }
            }
            blockers[i][j] = mask;
        }
    }


    auto is_path_clear = [&](int u_idx, int v_idx, int mask) {
        int gates_between = blockers[u_idx][v_idx];
        return (gates_between & ~mask) == 0;
    };

    auto is_final_path_clear = [&](ll p1, ll p2, int mask) {
        ll mn = min(p1, p2);
        ll mx = max(p1, p2);
        for (int i = 0; i < n; ++i) {
            if (!(mask & (1 << i))) {
                if (gate_pos[i] > mn && gate_pos[i] < mx) {
                    return false;
                }
            }
        }
        return true;
    };

    vector<unordered_map<int, ll>> dist(n + 1);
    priority_queue<State, vector<State>, greater<State>> pq;

    dist[0][0] = 0;
    pq.push({0, {0, 0}});

    while (!pq.empty()) {
        auto [d, state] = pq.top();
        auto [u_idx, u_mask] = state;
        pq.pop();

        if (!dist[u_idx].count(u_mask) || d > dist[u_idx][u_mask]) {
            continue;
        }

        ll u_pos = all_pos[u_idx];

        for (int i = 0; i < n; ++i) {
        if (!(u_mask & (1 << i))) {
            int v_idx = i + 1;
            ll v_pos = all_pos[v_idx];
            int v_mask = u_mask | (1 << i);

            if (is_path_clear(u_idx, v_idx, u_mask)) {
                ll new_dist = d + abs(v_pos - u_pos);

                ll current_v_dist = LLONG_MAX;
                if (dist[v_idx].count(v_mask)) {
                    current_v_dist = dist[v_idx][v_mask];
                }

                if (new_dist < current_v_dist) {
                        dist[v_idx][v_mask] = new_dist;
                        pq.push({new_dist, {v_idx, v_mask}});
                    }
                }
            }
        }

        ll min_cost = LLONG_MAX;

        if (is_final_path_clear(kate_pos, hatch_pos, 0)) {
        min_cost = abs(hatch_pos - kate_pos);
        }

        for (auto const& [mask, d] : dist[0]) {
            if (is_final_path_clear(kate_pos, hatch_pos, mask)) {
                ll total_cost = d + abs(hatch_pos - kate_pos);
                min_cost = min(min_cost, total_cost);
            }
        }

        for (int i = 0; i < n; ++i) {
            int loc_idx = i + 1;
            ll pos = all_pos[loc_idx];

            for (auto const& [mask, d] : dist[loc_idx]) {
                if (is_final_path_clear(pos, hatch_pos, mask)) {
                    ll total_cost = d + abs(hatch_pos - pos);
                    min_cost = min(min_cost, total_cost);
                }
            }
        }

        if (min_cost == LLONG_MAX) {
            return -1;
        } else {
            return min_cost;
        }
    }
}
int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int t;
    cin >> t;
    while (t--) {
        cout << solve() << "\n";
    }
    return 0;
}

