#include <bits/stdc++.h>
using namespace std;

int maxX = -1;
int maxY = -1;
bool found = false;
char resultColor = 'W';
vector<pair<int, int>> resultPath;

void dfs(int x, int y, set<pair<int, int>>& visited, char color, int n, vector<pair<int, int>>& path, set<pair<int, int>>& blacks, set<pair<int, int>>& whites) {
    if (found) return;
    visited.insert({x, y});
    path.push_back({x, y});
    if (path.size() == n) {
        found = true;
        resultColor = color;
        for (int i = 0; i < path.size(); i++) {
            resultPath.push_back(path[i]);
        }
        return;
    }
    if (y > maxY) {
        maxY = y;
        maxX = x;
    }
    vector<pair<int, int>> known, unknown;
    for (int i = -1; i <= 1; i++) {
        for (int j = -1; j <= 1; j++) {
            if (!(i == 0 && j == 0)) {
                int newX = x + i;
                int newY = y + j;
                if (visited.find({newX, newY}) != visited.end()) continue;
                if (blacks.count({newX, newY}) || whites.count({newX, newY})) {
                    known.push_back({newX, newY});
                } else {
                    unknown.push_back({newX, newY});
                }
            }
        }
    }
    for (int i = 0; i < known.size(); i++) {
        char newColor;
        if (blacks.count(known[i])) {
            newColor = 'B';
        } else {
            newColor = 'W';
        }
        if (newColor == color) {
            dfs(known[i].first, known[i].second, visited, color, n, path, blacks, whites);
        }
    }
    for (int i = 0; i < unknown.size(); i++) {
        char newColor;
        cout << "? " << unknown[i].first << " " << unknown[i].second << endl;
        cin >> newColor;
        if (newColor == color) {
            dfs(unknown[i].first, unknown[i].second, visited, color, n, path, blacks, whites);
        }
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t, n;
    cin >> t >> n;

    while (t--) {
        maxX = -1;
        maxY = -1;
        found = false;
        set<pair<int, int>> visited;
        set<pair<int, int>> blacks;
        set<pair<int, int>> whites;
        resultPath.clear();
        int x = maxX + 1;
        int y = maxY + 1;
        cout << "? " << x << " " << y << endl;
        char color;
        cin >> color;
        if (color == 'B') {
            color = 'W';
        } else {
            color = 'B';
        }
        while (!found) {
            if (color == 'B') {
                color = 'W';
            } else {
                color = 'B';
            }
            vector<pair<int, int>> path;
            
            dfs(maxX + 1, maxY + 1, visited, color, n, path, blacks, whites);
        }

        cout << "! " << resultColor << " ";
        for (int i = 0; i < resultPath.size(); i++) {
            cout << resultPath[i].first << " " << resultPath[i].second << " ";
        }
        cout << '\n';
    }
    return 0;
}
