#include <iostream>
#include <algorithm>
#include <array>

using namespace std;

int main() {
    int boxes;
    if (!(cin >> boxes)) {
        return 0;
    }

    array<int, 3> souvenir{};
    cin >> souvenir[0] >> souvenir[1] >> souvenir[2];
    sort(souvenir.begin(), souvenir.end());

    for (int i = 1; i < boxes; ++i) {
        array<int, 3> pack{};
        cin >> pack[0] >> pack[1] >> pack[2];
        sort(pack.begin(), pack.end());  // rotate optimally by keeping sorted order

        for (int d = 0; d < 3; ++d) {
            souvenir[d] = min(souvenir[d], pack[d]);
        }
    }

    long long volume = 1LL * souvenir[0] * souvenir[1] * souvenir[2];
    cout << volume << endl;
    return 0;
}
