#include <iostream>
#include <vector>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    unsigned int n;
    if (!(cin >> n)) {
        return 0;
    }

    if (n == 0) {
        cout << 0 << '\n';
        return 0;
    }

    vector<int> chunks;
    while (n > 0) {
        chunks.push_back(static_cast<int>(n & 0x7F));
        n >>= 7;
    }

    bool first = true;
    for (int i = static_cast<int>(chunks.size()) - 1; i >= 0; --i) {
        int byteVal = chunks[i];
        if (i > 0) {
            byteVal |= 0x80;  // continuation flag
        }
        if (!first) {
            cout << ' ';
        }
        first = false;
        cout << byteVal;
    }
    cout << '\n';
    return 0;
}
