#include <iostream>
#include <vector>
#include <queue>
#include <unordered_map>
#include <unordered_set>
#include <cstdlib>

using namespace std;

namespace {
    const int MAX_QUERIES = 30000;
    const int DX[8] = {-1, -1, -1, 0, 0, 1, 1, 1};
    const int DY[8] = {-1, 0, 1, -1, 1, -1, 0, 1};

    inline long long pack(int x, int y) {
        return (static_cast<long long>(x) << 32) ^ (static_cast<unsigned int>(y));
    }
}

struct GridExplorer {
    unordered_map<long long, char> colorCache;
    unordered_set<long long> blocked;
    long long queriesUsed = 0;

    char queryCell(int x, int y) {
        long long key = pack(x, y);
        auto it = colorCache.find(key);
        if (it != colorCache.end()) {
            return it->second;
        }
        if (queriesUsed >= MAX_QUERIES) {
            exit(0);
        }
        cout << "? " << x << ' ' << y << '\n';
        cout.flush();
        char resp;
        if (!(cin >> resp)) {
            exit(0);
        }
        if (resp == '0') {
            exit(0);
        }
        ++queriesUsed;
        colorCache[key] = resp;
        return resp;
    }

    vector<pair<int, int>> growComponent(int sx, int sy, char color, int need) {
        vector<pair<int, int>> comp;
        queue<pair<int, int>> q;
        unordered_set<long long> inComp;

        long long startKey = pack(sx, sy);
        if (blocked.count(startKey)) {
            return comp;
        }
        q.emplace(sx, sy);
        inComp.insert(startKey);
        comp.emplace_back(sx, sy);

        while (!q.empty() && static_cast<int>(comp.size()) < need) {
            auto [x, y] = q.front();
            q.pop();
            for (int dir = 0; dir < 8; ++dir) {
                int nx = x + DX[dir];
                int ny = y + DY[dir];
                long long key = pack(nx, ny);
                if (inComp.count(key)) {
                    continue;
                }
                char c = queryCell(nx, ny);
                if (c == color) {
                    inComp.insert(key);
                    q.emplace(nx, ny);
                    comp.emplace_back(nx, ny);
                    if (static_cast<int>(comp.size()) >= need) {
                        break;
                    }
                }
            }
        }

        if (static_cast<int>(comp.size()) < need) {
            for (const auto& cell : comp) {
                blocked.insert(pack(cell.first, cell.second));
            }
        }
        return comp;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t, n;
    if (!(cin >> t >> n)) {
        return 0;
    }

    GridExplorer explorer;

    for (int caseId = 0; caseId < t; ++caseId) {
        explorer.colorCache.clear();
        explorer.blocked.clear();

        vector<pair<int, int>> answer;
        char answerColor = 'B';
        bool solved = false;

        for (int layer = 0; !solved; ++layer) {
            for (int dx = -layer; dx <= layer && !solved; ++dx) {
                for (int dy = -layer; dy <= layer && !solved; ++dy) {
                    if (max(abs(dx), abs(dy)) != layer) {
                        continue;
                    }
                    int x = dx;
                    int y = dy;
                    long long key = pack(x, y);
                    if (explorer.blocked.count(key)) {
                        continue;
                    }
                    char color = explorer.queryCell(x, y);
                    auto comp = explorer.growComponent(x, y, color, n);
                    if (comp.size() >= static_cast<size_t>(n)) {
                        answer.assign(comp.begin(), comp.begin() + n);
                        answerColor = color;
                        solved = true;
                    }
                }
            }
        }

        cout << "! " << answerColor;
        for (const auto& cell : answer) {
            cout << ' ' << cell.first << ' ' << cell.second;
        }
        cout << '\n';
        cout.flush();
    }

    return 0;
}
