#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <complex>
#include <cmath>

using namespace std;
using namespace std;
using cd = complex<double>;
const double PI = acos(-1.0);
const int BASE = 1000000000;
const int CHUNK = 9;
void fft(vector<cd>& a, bool invert) {
    int n = static_cast<int>(a.size());
    for (int i = 1, j = 0; i < n; ++i) {
        int bit = n >> 1;
        for (; j & bit; bit >>= 1) {
            j ^= bit;
        }
        j ^= bit;
        if (i < j) {
            swap(a[i], a[j]);
        }
    }
    for (int len = 2; len <= n; len <<= 1) {
        double ang = 2 * PI / len * (invert ? -1 : 1);
        cd wlen(cos(ang), sin(ang));
        for (int i = 0; i < n; i += len) {
            cd w(1);
            for (int j = 0; j < len / 2; ++j) {
                cd u = a[i + j];
                cd v = a[i + j + len / 2] * w;
                a[i + j] = u + v;
                a[i + j + len / 2] = u - v;
                w *= wlen;
            }
        }
    }
void trim(vector<int>& v) {
    while (v.size() > 1 && v.back() == 0) {
        v.pop_back();
    if (invert) {
        for (cd& x : a) {
            x /= n;
        }
    }
}
vector<int> parseBigInt(const string& s) {
    vector<int> digits;
    for (int i = static_cast<int>(s.size()); i > 0; i -= CHUNK) {
        int start = max(0, i - CHUNK);
        int len = i - start;
        digits.push_back(stoi(s.substr(start, len)));
string multiplyStrings(const string& a, const string& b) {
    if (a == "0" || b == "0") {
        return "0";
    }
    trim(digits);
    return digits;
}
vector<int> multiply(const vector<int>& a, const vector<int>& b) {
    if (a.empty() || b.empty()) {
        return {0};
    vector<int> fa(a.size()), fb(b.size());
    for (int i = 0; i < (int)a.size(); ++i) {
        fa[i] = a[a.size() - 1 - i] - '0';
    }
    for (int i = 0; i < (int)b.size(); ++i) {
        fb[i] = b[b.size() - 1 - i] - '0';
    }
    int n = 1;
    while (n < (int)fa.size() + (int)fb.size()) {
        n <<= 1;
    }
    vector<cd> A(n), B(n);
    for (int i = 0; i < (int)fa.size(); ++i) {
        A[i] = cd(fa[i], 0);
    }
    for (int i = 0; i < (int)fb.size(); ++i) {
        B[i] = cd(fb[i], 0);
    }
    vector<__int128_t> tmp(a.size() + b.size());
    for (size_t i = 0; i < a.size(); ++i) {
        for (size_t j = 0; j < b.size(); ++j) {
            tmp[i + j] += static_cast<__int128_t>(a[i]) * b[j];
        }
    fft(A, false);
    fft(B, false);
    for (int i = 0; i < n; ++i) {
        A[i] *= B[i];
    }
    fft(A, true);
    vector<int> result(tmp.size());
    vector<int> result(n);
    long long carry = 0;
    for (size_t k = 0; k < tmp.size(); ++k) {
        __int128_t cur = tmp[k] + carry;
        result[k] = static_cast<int>(cur % BASE);
        carry = static_cast<long long>(cur / BASE);
    for (int i = 0; i < n; ++i) {
        long long val = static_cast<long long>(llround(A[i].real())) + carry;
        result[i] = static_cast<int>(val % 10);
        carry = val / 10;
    }
    while (carry > 0) {
        result.push_back(static_cast<int>(carry % BASE));
        carry /= BASE;
        result.push_back(static_cast<int>(carry % 10));
        carry /= 10;
    }
    while (result.size() > 1 && result.back() == 0) {
        result.pop_back();
    }
    trim(result);
    return result;
}
bool equalBigInt(vector<int> lhs, vector<int> rhs) {
    trim(lhs);
    trim(rhs);
    return lhs == rhs;
    string product;
    product.reserve(result.size());
    for (auto it = result.rbegin(); it != result.rend(); ++it) {
        product.push_back(char('0' + *it));
    }
    return product;
}
int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    string s, c_str;
    if (!(cin >> s >> c_str)) {
    string s, c;
    if (!(cin >> s >> c)) {
        return 0;
    }
    int len_s = static_cast<int>(s.size());
    int len_c = static_cast<int>(c_str.size());
    int len_s = s.size();
    int len_c = c.size();
    vector<int> candidates;
    auto addCandidate = [&](int m) {
    }
    sort(candidates.begin(), candidates.end());
    candidates.erase(unique(candidates.begin(), candidates.end()), candidates.end());
    vector<int> c_big = parseBigInt(c_str);
    for (int m : candidates) {
        int split = len_s - m;
        if (split <= 0 || split >= len_s) {
    for (int lb : candidates) {
        int la = len_s - lb;
        if (la <= 0 || la >= len_s) {
            continue;
        }
        string a_str = s.substr(0, split);
        string b_str = s.substr(split);
        string a_str = s.substr(0, la);
        string b_str = s.substr(la);
        if ((a_str.size() > 1 && a_str[0] == '0') || (b_str.size() > 1 && b_str[0] == '0')) {
            continue;
        }
        vector<int> a_big = parseBigInt(a_str);
        vector<int> b_big = parseBigInt(b_str);
        vector<int> prod = multiply(b_big, c_big);
        if (equalBigInt(prod, a_big)) {
            cout << a_str << " " << b_str << "\n";
        string prod = multiplyStrings(b_str, c);
        if (prod == a_str) {
            cout << a_str << ' ' << b_str << '\n';
            return 0;
        }
    }