#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <complex>
#include <cmath>

using namespace std;

using cd = complex<double>;
const double PI = acos(-1.0);

void fft(vector<cd>& a, bool invert) {
    int n = static_cast<int>(a.size());
    for (int i = 1, j = 0; i < n; ++i) {
        int bit = n >> 1;
        for (; j & bit; bit >>= 1) {
            j ^= bit;
        }
        j ^= bit;
        if (i < j) {
            swap(a[i], a[j]);
        }
    }

    for (int len = 2; len <= n; len <<= 1) {
        double ang = 2 * PI / len * (invert ? -1 : 1);
        cd wlen(cos(ang), sin(ang));
        for (int i = 0; i < n; i += len) {
            cd w(1);
            for (int j = 0; j < len / 2; ++j) {
                cd u = a[i + j];
                cd v = a[i + j + len / 2] * w;
                a[i + j] = u + v;
                a[i + j + len / 2] = u - v;
                w *= wlen;
            }
        }
    }

    if (invert) {
        for (cd& x : a) {
            x /= n;
        }
    }
}

string multiplyStrings(const string& a, const string& b) {
    if (a == "0" || b == "0") {
        return "0";
    }

    vector<int> fa(a.size()), fb(b.size());
    for (int i = 0; i < (int)a.size(); ++i) {
        fa[i] = a[a.size() - 1 - i] - '0';
    }
    for (int i = 0; i < (int)b.size(); ++i) {
        fb[i] = b[b.size() - 1 - i] - '0';
    }

    int n = 1;
    while (n < (int)fa.size() + (int)fb.size()) {
        n <<= 1;
    }
    vector<cd> A(n), B(n);
    for (int i = 0; i < (int)fa.size(); ++i) {
        A[i] = cd(fa[i], 0);
    }
    for (int i = 0; i < (int)fb.size(); ++i) {
        B[i] = cd(fb[i], 0);
    }

    fft(A, false);
    fft(B, false);
    for (int i = 0; i < n; ++i) {
        A[i] *= B[i];
    }
    fft(A, true);

    vector<int> result(n);
    long long carry = 0;
    for (int i = 0; i < n; ++i) {
        long long val = static_cast<long long>(llround(A[i].real())) + carry;
        result[i] = static_cast<int>(val % 10);
        carry = val / 10;
    }
    while (carry > 0) {
        result.push_back(static_cast<int>(carry % 10));
        carry /= 10;
    }
    while (result.size() > 1 && result.back() == 0) {
        result.pop_back();
    }

    string product;
    product.reserve(result.size());
    for (auto it = result.rbegin(); it != result.rend(); ++it) {
        product.push_back(char('0' + *it));
    }
    return product;
}

bool hasLeadingZero(const string& s) {
    return s.size() > 1 && s[0] == '0';
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    string s, c;
    if (!(cin >> s >> c)) {
        return 0;
    }

    int len_s = static_cast<int>(s.size());
    int len_c = static_cast<int>(c.size());

    vector<int> candidates;
    auto addCandidate = [&](int m) {
        if (m > 0 && m < len_s) {
            candidates.push_back(m);
        }
    };

    int diff = len_s - len_c;
    if (diff >= 0 && diff % 2 == 0) {
        addCandidate(diff / 2);
    }
    if ((diff + 1) >= 0 && (diff + 1) % 2 == 0) {
        addCandidate((diff + 1) / 2);
    }

    sort(candidates.begin(), candidates.end());
    candidates.erase(unique(candidates.begin(), candidates.end()), candidates.end());

    for (int lb : candidates) {
        int la = len_s - lb;
        if (la <= 0 || la >= len_s) {
            continue;
        }
        string a_str = s.substr(0, la);
        string b_str = s.substr(la);
        if (hasLeadingZero(a_str) || hasLeadingZero(b_str)) {
            continue;
        }

        string prod = multiplyStrings(b_str, c);
        if (prod == a_str) {
            cout << a_str << ' ' << b_str << '\n';
            return 0;
        }
    }

    return 0;
}
