#include <iostream>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if (!(cin >> t)) {
        return 0;
    }
    while (t--) {
        int n;
        cin >> n;
        vector<string> first(n), second(n);
        for (int i = 0; i < n; ++i) {
            cin >> first[i] >> second[i];
        }

        unordered_map<string, int> cntFirst;
        unordered_map<string, int> cntSecond;
        cntFirst.reserve(n * 2);
        cntSecond.reserve(n * 2);
        for (int i = 0; i < n; ++i) {
            ++cntFirst[first[i]];
            ++cntSecond[second[i]];
        }

        bool ok = true;
        for (int i = 0; i < n && ok; ++i) {
            --cntFirst[first[i]];
            --cntSecond[second[i]];
            if (i == n - 1) {
                break;
            }
            bool similarAvailable = (cntFirst[first[i]] > 0) || (cntSecond[second[i]] > 0);
            if (similarAvailable) {
                bool nextSimilar = (first[i] == first[i + 1]) || (second[i] == second[i + 1]);
                if (!nextSimilar) {
                    ok = false;
                }
            }
        }

        cout << (ok ? "Yes" : "No") << '\n';
    }

    return 0;
}
