#include <iostream>
#include <vector>
#include <set>
#include <vector>
#include <algorithm>
#include <cmath>
#include <unordered_map>
#include <unordered_set>
#include <map>
#include <queue>
#include <stack>
#include <deque>
#include <random>
#include <bitset>
#include <cassert>

#pragma GCC optimize("Ofast,no-stack-protector,unroll-loops,fast-math,O3")
#pragma GCC target("sse,sse2,sse3,ssse3,sse4,popcnt,abm,mmx,avx")
#pragma GCC optimize("Ofast")//Comment optimisations for interactive problems (use endl)
#pragma GCC target("avx,avx2,fma")
#pragma GCC optimization ("unroll-loops")

using ld = long double;
using namespace std;
mt19937 rnd(179);
const int MAXSZ = 2000 * 500 + 1;
const int MAXN = 2001;
bitset<MAXSZ> a[MAXN];

int n;
vector<tuple<char, int, string>> inp;

void input() {
    cin >> n;
    inp.assign(n + 1, {});
    inp[0] = make_tuple('=', 0, "sync");
    for (int i = 1 ;i <= n; i++) {
        cin >> get<0>(inp[i]) >> get<1>(inp[i]) >> get<2>(inp[i]);
    }
    n++;
}

int solve() {
    // input();
    bitset<MAXSZ> res;
    int sumAll = 0;
    for (int i = 0;i < (int)inp.size(); i++) {
        if (get<0>(inp[i]) == '+') sumAll += get<1>(inp[i]);
    }
    assert(sumAll <= MAXSZ);
    bitset<MAXSZ> temp;
    temp[0] = 1;
    int lst = -1;
    for (int i = 0; i < (int)inp.size(); i++) if (get<0>(inp[i]) == '=') {
        lst = i;
        assert(sumAll + get<1>(inp[i]) <= MAXSZ);
    }
    for (int i = 0; i < (int)inp.size(); i++) {
        if (get<0>(inp[i]) == '+') sumAll -= get<1>(inp[i]);
        if (get<2>(inp[i]) == "async" && get<0>(inp[i]) == '+') {
            a[i] = temp;
            temp |= (temp << get<1>(inp[i]));
        }
        if (i == lst && get<0>(inp[i]) == '=' && get<2>(inp[i]) == "sync") {
            // cout << "SUM ALL " << sumAll << endl;
            temp <<= (sumAll + get<1>(inp[i]));
            res |= temp;
            temp >>= (sumAll + get<1>(inp[i]));
            // res |= (temp << sumAll);
            // for (int x = 0; x < MAXSZ; x++) if (res[x]) cout << x << " ";
            // cout << endl;
        }
    }
    bitset<MAXSZ> temp2 = temp;
    sumAll = 0;
    for (int i = (int)inp.size() - 1; i >= 0; i--) {
        if (get<0>(inp[i]) == '+' && i > lst) {
            sumAll += get<1>(inp[i]);
            if (get<2>(inp[i]) == "async") temp = a[i];
            temp2 |= (temp << sumAll);
        }
        if (get<0>(inp[i]) == '=' && get<2>(inp[i]) == "async") {
            res |= (temp2 << get<1>(inp[i]));
        }
    }
    // cout << "RES: ";
    // for (int x = 0; x < MAXSZ; x++) if (res[x]) cout << x << " ";
    // cout << endl;
    return res.count();
    cout << res.count() << '\n';
}

int stupidSolve() {
    int ans = 0;
    set<int> vals;
    for (int mask = 0; mask < (1 << n); mask++) {
        bool ch1 = true;
        int lst = -1;
        vector<int> inds1, inds2, inds;
        for (int i = 0; i < n; i++) {
            if (mask & (1 << i)) {
                if (get<0>(inp[i]) == '=') {
                    if (lst != -1) ch1 = false;
                    else lst = i;
                } else {
                    if (get<2>(inp[i]) == "sync") inds1.push_back(i);
                    else inds2.push_back(i);
                    inds.push_back(i);
                }
            }
        }
        if (lst == -1) continue;
        for (int j : inds1) {
            if (j < lst) ch1 = false;
        }
        if (get<2>(inp[lst]) == "sync") {
            for (int i = lst + 1; i < n; i++) {
                if (get<0>(inp[i]) == '=') ch1 = false;
            }
        }
        if (!inds1.empty()) {
            for (int i = 0; i < n; i++) {
                if (i > inds1[0] && get<0>(inp[i]) == '+' && (lower_bound(inds.begin(), inds.end(), i) == inds.end() || *lower_bound(inds.begin(), inds.end(), i) != i)) {
                    ch1 = false;
                }
                if (get<0>(inp[i]) == '=' && i > lst && i > inds1[0]) ch1 = false;
            }
        }
        if (get<2>(inp[lst]) == "sync") {
            for (int i = lst + 1; i < n; i++) {
                if (get<0>(inp[i]) == '+' && (lower_bound(inds.begin(), inds.end(), i) == inds.end() || *lower_bound(inds.begin(), inds.end(), i) != i)) {
                    ch1 = false;
                }
            }
        }
        if (!ch1) continue;
        int val = get<1>(inp[lst]);
        for (int j : inds) val += get<1>(inp[j]);
        // if (val > 40) cout << "YEP " << bitset<11>(mask) << " " << val << endl;
        vals.insert(val);
    }
    return (int)vals.size();
}

void gen() {
    n = 2 + rnd() % 6;
    inp.assign(n, {});
    inp[0] = make_tuple('=', 0, "sync");
    for (int i = 1; i < n; i++) {
        if (rnd() % 2 == 0) get<0>(inp[i]) = '=';
        else get<0>(inp[i]) = '+';

        get<1>(inp[i]) = 1 + rnd() % 10;

        if (rnd() % 2 == 0) get<2>(inp[i]) = "sync";
        else get<2>(inp[i]) = "async";
    }
}

void stress() {
    int it = 0;
    while (true) {
        cout << "TEST " << it << endl;
        gen();
        cout << n - 1 << '\n';
        for (int i = 1; i < n; i++) {
            auto [c, x, s] = inp[i];
            cout << c << " " << x << " " << s << '\n';
        }
        cout << '\n';
//9 13 8 12 16
        auto ans1 = solve();
        auto ans2 = stupidSolve();
        if (ans1 != ans2) {
            cout << "FOUND!!!" << ans1 << " " << ans2 << '\n';
            return;
        }
        it++;
    }
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.precision(30);

    int t = 1;
    // cin >> t;
    while (t--) {
        input();
        int out = solve();
        // int out = stupidSolve();
        cout << out << '\n';
    }
}