#include "testlib.h"

const int MAX = 1'000;

void genYesEqualLen() {
    while (true) {
        int a = rnd.next(0, MAX);
        int b = rnd.next(0, MAX);
        int hi = std::min(MAX, a + b);
        int lo = std::max(a, b);
        if (lo > hi) {
        	continue;
        }
        int c = rnd.next(lo, hi);
        std::cout << a << ' ' << b << ' ' << c << std::endl;
        break;
    }
}

void genYesLine() {
    int p = rnd.next(0, MAX);
    int q = rnd.next(0, MAX - p);
    std::array<int, 3> v = {p, q, p + q};
    shuffle(v.begin(), v.end());
    std::cout << v[0] << ' ' << v[1] << ' ' << v[2] << std::endl;
}

void genYesSpecial(int type) {
    if (type == 0) {
    	std::cout << 0 << ' ' << 0 << ' ' << 0 << std::endl;
    } else if (type == 1) {
    	int k = rnd.next(1, MAX);
    	std::cout << 0 << ' ' << k << ' ' << k << std::endl;
    } else if (type == 2) {
    	int k = rnd.next(1, MAX);
    	std::cout << k << ' ' << 0 << ' ' << k << std::endl;
    } else if (type == 3) {
    	int k = rnd.next(1, MAX);
    	std::cout << k << ' ' << k << ' ' << 0 << std::endl;
    } else if (type == 4) {
    	int k = rnd.next(1, MAX);
    	std::cout << k << ' ' << k << ' ' << k << std::endl;
    } else {
    	genYesEqualLen();
    }
}

void genNoBigSide() {
    int b = rnd.next(0, 700);
    int c = rnd.next(0, 700 - b);
    int a = b + c + rnd.next(1, 300);
    std::cout << a << ' ' << b << ' ' << c << std::endl;
}

void genNoLowerBound() {
    int a = rnd.next(0, MAX);
    int b = rnd.next(0, MAX);
    int gap = abs(a - b);
    if (gap == 0) {
        a = rnd.next(400, 1000);
        b = rnd.next(0, a - 200);
        gap = a - b;
    }
    int c = rnd.next(0, std::max(0, gap - 1));
    std::cout << a << ' ' << b << ' ' << c << std::endl;
}

void genNoZero() {
    int x = rnd.next(1, MAX);
    std::cout << 0 << ' ' << 0 << ' ' << x << std::endl;
}

int main(int argc, char** argv) {
	registerGen(argc, argv, 1);

	int type = atoi(argv[1]);
	if (type == 0) {
		genYesEqualLen();
	} else if (type == 1) {
		genYesLine();
	} else if (type == 2) {
		int subtype = atoi(argv[2]);
		genYesSpecial(subtype);
	} else if (type == 3) {
		genNoBigSide();
	} else if (type == 4) {
		genNoLowerBound();
	} else if (type == 5) {
		genNoZero();
	}

	return 0;
}
