///////////////////////////////    _LeMur_
#define _CRT_SECURE_NO_WARNINGS
#include <unordered_map>
#include <unordered_set>
#include <algorithm>
#include <iostream>
#include <cstring>
#include <complex>
#include <cassert>
#include <cfloat>
#include <memory>
#include <chrono>
#include <random>
#include <climits>
#include <limits>
#include <bitset>
#include <cstdio>
#include <vector>
#include <string>
#include <stack>
#include <tuple>
#include <queue>
#include <ctime>
#include <cmath>
#include <list>
#include <map>
#include <set>

using namespace std;

const int N = 200005;
const int inf = 1000 * 1000 * 1000;
const int mod = 1000 * 1000 * 1000 + 7;
// mt19937 myrand(chrono::steady_clock::now().time_since_epoch().count());
mt19937 myrand(373);

int t;
int n, m;

vector <int> g[N];
bool used[N];
int tin[N], timer;
bool go[N];

int parent[N];
int sz[N];

int findher(int v) {
  if (v == parent[v]) return v;
  return parent[v] = findher(parent[v]);
}

void merge(int a, int b) {
  a = findher(a);
  b = findher(b);
  if (a == b) return;
  if (sz[a] > sz[b]) swap(a, b);
  parent[a] = b;
  sz[b] += sz[a];
  sz[a] = 0;
}

bool dfs(int v, int p) {
  tin[v] = ++timer;
  used[v] = true;
  go[v] = false;

  vector <int> children;

  for (int to: g[v]) {
    if (used[to]) {
      if (tin[to] < tin[p]) {
        go[v] = true;
      }
      continue;
    }
    bool f = dfs(to, v);
    if (f) {
      children.push_back(to);
    }
  }

  // cout << v << " " << (int)children.size() << endl;

  if ((int)children.size() % 2) {
    for (int gag: children) {
      merge(v, gag);
    }
    return false;
  }

  int vertex = -1;
  for (int gag: children) {
    if (go[gag]) {
      vertex = gag;
      break;
    }
  }

  for (int gag: children) {
    if (gag == vertex) continue;
    merge(v, gag);
  }

  if (vertex != -1) {
    used[vertex] = false;
  }

  if (vertex == -1) return true;
  return false;
}

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(NULL);

  cin >> t;

  while (t--) {
    cin >> n >> m;

    for (int i = 1; i <= m; i++) {
      int a, b;
      cin >> a >> b;
      g[a].push_back(b);
      g[b].push_back(a);
    }

    if (n % 2) {
      cout << -1 << endl;
      for (int i = 1; i <= n; i++) {
        g[i].clear();
      }
      continue;
    }

    for (int i = 1; i <= n; i++) {
      used[i] = false;
      parent[i] = i;
      sz[i] = 1;
    }

    timer = 0;
    bool flag = dfs(1, 0);
    assert(!flag);

    vector <int> color(n + 1);
    for (int i = 1; i <= n; i++) {
      color[i] = findher(i);
      cout << findher(i) << " ";
    }
    cout << endl;

    for (int i = 1; i <= n; i++) {
      int counter = 1;
      for (int to: g[i]) {
        if (color[to] == color[i]) {
          ++counter;
        }
      }
      assert(counter % 2 == 0);
    }

    for (int i = 1; i <= n; i++) {
      g[i].clear();
    }
  }
  return 0;
}
