/**
 *    author:  tourist
 *    created: 05.11.2025 19:32:42
**/
#include <bits/stdc++.h>

using namespace std;

#ifdef LOCAL
#include "algo/debug.h"
#else
#define debug(...) 42
#endif

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);
  int tt;
  cin >> tt;
  while (tt--) {
    int n, m;
    cin >> n >> m;
    vector<vector<int>> g(n);
    for (int i = 0; i < m; i++) {
      int x, y;
      cin >> x >> y;
      --x; --y;
      g[x].push_back(y);
      g[y].push_back(x);
    }
    vector<int> depth(n, -1);
    vector<vector<pair<int, int>>> up(n);
    vector<vector<int>> children(n);
    vector<pair<int, int>> later;
    vector<int> res(n, -1);
    int cnt = 0;
    bool fail = false;
    auto Dfs = [&](auto&& self, int v) -> void {
      for (int u : g[v]) {
        if (depth[u] == -1) {
          depth[u] = depth[v] + 1;
          self(self, u);
        } else {
          if (depth[u] < depth[v]) {
            up[v].emplace_back(depth[u], u);
          }
        }
      }
      sort(up[v].begin(), up[v].end());
      for (int u : children[v]) {
        assert(!up[u].empty() && up[u].back().second == v);
      }
      if (children[v].size() % 2 == 1) {
        res[v] = cnt;
        for (int u : children[v]) {
          res[u] = cnt;
        }
        cnt += 1;
        return;
      }
      for (int u : children[v]) {
        if (up[u].size() > 1) {
          up[u].pop_back();
          children[up[u].back().second].push_back(u);
          res[v] = cnt;
          for (int w : children[v]) {
            if (w != u) {
              res[w] = cnt;
            }
          }
          cnt += 1;
          return;
        }
      }
      if (up[v].empty()) {
        fail = true;
      } else {
        for (int u : children[v]) {
          later.emplace_back(u, v);
        }
        children[up[v].back().second].push_back(v);
      }
    };
    for (int i = 0; i < n; i++) {
      if (depth[i] == -1) {
        depth[i] = 0;
        Dfs(Dfs, i);
      }
    }
    if (fail) {
      cout << -1 << '\n';
    } else {
      for (auto& [u, v] : views::reverse(later)) {
        res[u] = res[v];
      }
      for (int i = 0; i < n; i++) {
        cout << res[i] + 1 << " \n"[i == n - 1];
      }
    }
  }
  return 0;
}
