#include <cassert>

#include "testlib.h"
 
using namespace std;

const int MIN_SIZE = -1;
const int MIN_VALUE = 2;
const int MAX_VALUE = 1'000'000'000;

bool readAndCheckSample(InStream& in, const int maxSize, const int h) {
    const int size = in.readInt(MIN_SIZE, maxSize, "k");
    if (size == -1) {
        return false;
    }

    vector<int> collection(size);
    for (auto& elem : collection) {
        elem = in.readInt(MIN_VALUE, MAX_VALUE, "collection_element");
    }

    map<int, pair<int, int>> minMaxScore{
        {2, {0, 0}},
        {4, {0, 4}},
    };
    for (int x = 3; x <= maxSize + 1; x++) {
        int value = (1 << x);
        const auto [min, max] = minMaxScore[value / 2];
        minMaxScore[value] = {min * 2 + value, max * 2 + value};
    }

    sort(collection.begin(), collection.end(), greater<int>());
    int minScore = 0;
    int maxScore = 0;
    for (const auto elem : collection) {
        if (!minMaxScore.count(elem)) {
            in.quitf(_wa, "Element is not reachable");
        }
        const auto maxElem = minMaxScore.rbegin()->first;
        auto [minAdd, maxAdd] = minMaxScore[elem];
        if (elem == maxElem) {
            maxAdd -= 4;
        }
        minScore += minAdd;
        maxScore += maxAdd;
        minMaxScore.erase(maxElem);
    }

    if (!(minScore <= h && h <= maxScore && h % 4 == 0)) {
        in.quitf(_wa, "Score is not reachable with given collection");
    }
    return true;
}

vector<bool> readAndCheckAnswer(InStream& in, const int k, const vector<int>& hs) {
    vector<bool> result;
    result.reserve(hs.size());

    for (const auto h : hs) {
        result.push_back(readAndCheckSample(in, k, h));
    }

    return result;
}
 
int main(int argc, char *argv[]) {
    registerTestlibCmd(argc, argv);
 
    const int n = inf.readInt();
    const int k = inf.readInt();
    vector<int> hs(n);
    for (int& h : hs) {
        h = inf.readInt();
    }
 
    const auto juryAnswer = readAndCheckAnswer(ans, k, hs);
    const auto partAnswer = readAndCheckAnswer(ouf, k, hs);

    assert(juryAnswer.size() == hs.size());
    assert(partAnswer.size() == hs.size());

    for (int i = 0; i < hs.size(); i++) {
        const bool juryFound = juryAnswer[i];
        const bool partFound = partAnswer[i];
        if (!juryFound && partFound) {
            quitf(_fail, "Participant found a solution, but jury didn't");
        }
    }
    for (int i = 0; i < hs.size(); i++) {
        const bool juryFound = juryAnswer[i];
        const bool partFound = partAnswer[i];
        if (juryFound && !partFound) {
            quitf(_wa, "Participant did not found a solution, jury did");
        }
    }
 
    quitf(_ok, "OK");
}
