import argparse


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--k', type=int, help='K from the problem statement')
    args = parser.parse_args()

    minMax = {4: (0, 4)}
    for i in range(3, args.k + 2):
        x = 2 ** i
        a, b = minMax[x // 2]
        minMax[x] = (a * 2 + x, b * 2 + x)

    baseScores = []
    for (x, y) in minMax.values():
        for baseScore in (x, y):
            baseScores.append(baseScore)

    keys = sorted(minMax.keys(), reverse=True)
    for cnt in range(1, len(keys) + 1):
        curKeys = keys[:cnt]
        baseScore = sum(max(0, minMax[k][1] - 4) for k in curKeys)
        baseScores.append(baseScore)

    scores = []
    for baseScore in baseScores:
        for deltaSteps in range(-2, 3):
            score = baseScore + deltaSteps * 4
            if score > 0:
                scores.append(score)

    scores = sorted(set(scores))
    print(len(scores), args.k)
    for score in scores:
        print(score)


if __name__ == '__main__':
    main()
