import argparse
import random
import sys


def main():
    rndSeed = ' '.join(sys.argv)
    rnd = random.Random(rndSeed)
    print("seed:", hash(rndSeed), file=sys.stderr)

    parser = argparse.ArgumentParser()
    parser.add_argument('--k', type=int, help='K from the problem statement')
    parser.add_argument('--from', type=int, help='Start of the range (inclusive)')
    parser.add_argument('--count', type=int, help='Number of integers to generate')
    parser.add_argument('--step', type=int, default=1, help='Step between integers (default: 1)')
    parser.add_argument('--no-shuffle', action='store_true', help='Do not shuffle the output')
    parser.add_argument('--seeds', type=str, nargs='*', help='List of seeds to initialize the random generator')
    args = parser.parse_args()

    numbers = []
    nextNumber = getattr(args, 'from')
    for _ in range(args.count):
        numbers.append(nextNumber)
        nextNumber += args.step

    if not args.no_shuffle:
        rnd.shuffle(numbers)

    print(len(numbers), args.k)
    for number in numbers:
        print(number)


if __name__ == '__main__':
    main()
