#include <algorithm>
#include <array>
#include <bitset>
#include <cassert>
#include <chrono>
#include <cstdint>
#include <cstring>
#include <functional>
#include <iomanip>
#include <iostream>
#include <map>
#include <numeric>
#include <queue>
#include <random>
#include <set>
#include <stack>
#include <vector>

using namespace std;

// BEGIN NO SAD
#define rep(i, a, b) for(int i = a; i < (b); ++i)
#define trav(a, x) for(auto& a : x)
#define all(x) x.begin(), x.end()
#define sz(x) (int)(x).size()
#define mp make_pair
#define pb push_back
#define eb emplace_back
#define lb lower_bound
#define ub upper_bound
typedef vector<int> vi;
#define f first
#define s second
#define derr if(1) cerr

// thanks gena
#ifdef LOCAL
#include "algo/debug.h"
#else
#define debug(...) 67
#endif
// END NO SAD

template<class Fun>
class y_combinator_result {
  Fun fun_;
public:
  template<class T>
  explicit y_combinator_result(T &&fun): fun_(std::forward<T>(fun)) {}

  template<class ...Args>
  decltype(auto) operator()(Args &&...args) {
    return fun_(std::ref(*this), std::forward<Args>(args)...);
  }
};

template<class Fun>
decltype(auto) y_combinator(Fun &&fun) {
  return y_combinator_result<std::decay_t<Fun>>(std::forward<Fun>(fun));
}

template<class T>
bool updmin(T& a, T b) {
  if(b < a) {
    a = b;
    return true;
  }
  return false;
}
template<class T>
bool updmax(T& a, T b) {
  if(b > a) {
    a = b;
    return true;
  }
  return false;
}
typedef int64_t ll;

struct disjoint_set {
  vector<int> p, sz;
  disjoint_set(int n) {
    p.assign(n, -1);
    sz.assign(n, 1);
  }
  int find(int x) {
    return p[x] < 0 ? x : (p[x] = find(p[x]));
  }
  int getsz(int x) {
    return sz[find(x)];
  }
  bool merge(int x, int y) {
    // x goes to y
    x = find(x);
    y = find(y);
    if(x == y) return false;
    p[x] = y;
    sz[y] += sz[x];
    return true;
  }
};

int n;
void rsolve() {
  int r = 25, c = 24;
  vector<string> g(r);
  for(int i = 0; i < r; i++) {
    g[i] = "";
    for(int j = 0; j < c; j++) {
    cout << "? " << i << " " << j << endl;
      char c;
      cin >> c;
      g[i] += c;
    }
  }
  disjoint_set dsu(600);
  for(int i = 0; i < r; i++) {
    for(int j = 0; j < c; j++) {
      for(int dx = -1; dx <= 1; dx++) for(int dy = -1; dy <= 1; dy++) {
        int nx = i + dx;
        int ny = j + dy;
        if(nx >= 0 && nx < r && ny >= 0 && ny < c && g[i][j] == g[nx][ny]) dsu.merge(i*c+j, nx*c+ny);
      }
    }
  }
  vector<vector<bool>> seen(r);
  for(auto& x: seen) x.resize(c);
  for(int i = 0; i < 600; i++) {
    if(dsu.getsz(i) >= n) {
      cout << "! " << g[i/c][i%c];
      seen[i/c][i%c] = true;
      vector<array<int, 2>> v;
      v.pb({i/c, i%c});
      for(int a = 0; a < sz(v) && sz(v) < n; a++) {
        for(int dx = -1; dx <= 1; dx++) for(int dy = -1; dy <= 1 && sz(v) < n; dy++) {
          int nx = v[a][0] + dx;
          int ny = v[a][1] + dy;
          if(nx < 0 || nx >= r || ny < 0 || ny >= c || g[nx][ny] != g[i/c][i%c]) continue;
          if(seen[nx][ny]) continue;
          seen[nx][ny] = true;
          v.pb({nx, ny});
        }
      }
      for(auto [a, b]: v) cout << " " << a << " " << b;
      cout << endl;
      return;
    }
  }
  assert(false);
}
void solve() {
  int q;
  cin >> q >> n;
  while(q--) {
    rsolve();
  }
}

// what would chika do
// are there edge cases (N=1?)
// are array sizes proper (scaled by proper constant, for example 2* for koosaga tree)
// integer overflow?
// are you doing geometry in floating points
// have you tried rereading the problem statement

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(NULL);
  solve();
}
