import java.io.*;
import java.util.*;
import java.util.Map.*;

public class MainSlow {
	FastScanner in;
	PrintWriter out;
	boolean systemIO = true;

	int n;
	int INF = 40000;

	int[] dx = { -1, -1, -1, 0, 0, 1, 1, 1 };
	int[] dy = { -1, 0, 1, -1, 1, -1, 0, 1 };
	
	public boolean request(int[] q) {
		System.out.println("? " + q[0] + " " + q[1]);
		String s = in.next();
		if (s.equals("0")) {
			System.exit(0);
		}
		return s.equals("W");
	}
	
	public int toInt(int[] q) {
		return q[0] * INF + q[1];
	}
	
	public void solve() {
		HashMap<Integer, Boolean> map = new HashMap<>();
		int[] sz = { 0, 0 };
		int[] q = { INF / 4, INF / 4 };
		@SuppressWarnings("unchecked")
		ArrayList<Integer>[] ans = new ArrayList[2];
		ans[0] = new ArrayList<>();
		ans[1] = new ArrayList<>();
		boolean c0 = request(q);
		map.put(toInt(q), c0);
		if (c0) {
			++sz[1];
			ans[1].add(toInt(q));
		} else {
			++sz[0];
			ans[0].add(toInt(q));
		}
		while (sz[0] < n && sz[1] < n) {
			boolean find = false;
			boolean c;
			int h = -1;
			for (Entry<Integer, Boolean> e : map.entrySet()) {
				int x = e.getKey() / INF;
				int y = e.getKey() % INF;
				for (int k = 0; k < 8; ++k) {
					q[0] = x + dx[k];
					q[1] = y + dy[k];
					h = toInt(q);
					if (map.containsKey(h)) {
						continue;
					}
					int zero = 0;
					int one = 0;
					for (int k1 = 0; k1 < 8; ++k1) {
						int x1 = q[0] + dx[k1];
						int y1 = q[1] + dy[k1];
						int[] q1 = { x1, y1 };
						if (map.containsKey(toInt(q1))) {
							if (map.get(toInt(q1))) {
								++one;
							} else {
								++zero;
							}
						}
					}
					if ((zero > 0 || sz[0] == 0) && (one > 0 || sz[1] == 0)) {
						c = request(q);
						if (c) {
							++sz[1];
							ans[1].add(h);
						} else {
							++sz[0];
							ans[0].add(h);
						}
						find = true;
						map.put(h, c);
						break;
					}
				}
				if (find) {
					break;
				}
			}
			if (find) {
				continue;
			}
//			System.out.println("HERE " + sz[0] + " " + sz[1]);
			int key = 0;
			boolean col = false;
			for (Entry<Integer, Boolean> e : map.entrySet()) {
				if (e.getKey() % INF > key % INF) {
					key = e.getKey();
					col = e.getValue();
				}
			}
			if (col) {
				sz[0] = 0;
				ans[0].clear();
			} else {
				sz[1] = 0;
				ans[1].clear();
			}
		}
		boolean col = sz[1] == n;
		if (col) {
			System.out.print("! W");
			for (int x : ans[1]) {
				System.out.print(" " + x / INF + " " + x % INF);
			}
			System.out.println();
		} else {
			System.out.print("! B");
			for (int x : ans[0]) {
				System.out.print(" " + x / INF + " " + x % INF);
			}
			System.out.println();
		}
	}
	
	public void run() {
		try {
			if (systemIO) {
				in = new FastScanner(System.in);
				out = new PrintWriter(System.out);
			} else {
				in = new FastScanner(new File("input.txt"));
				out = new PrintWriter(new File("output.txt"));
			}
			
			int t = in.nextInt();
			n = in.nextInt();
			
			for (int i = 0; i < t; ++i) {
				solve();
			}

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	class FastScanner {
		BufferedReader br;
		StringTokenizer st;

		FastScanner(File f) {
			try {
				br = new BufferedReader(new FileReader(f));
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		}

		FastScanner(InputStream f) {
			br = new BufferedReader(new InputStreamReader(f));
		}

		String nextLine() {
			try {
				return br.readLine();
			} catch (IOException e) {
				return null;
			}
		}

		String next() {
			while (st == null || !st.hasMoreTokens()) {
				try {
					st = new StringTokenizer(br.readLine());
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			return st.nextToken();
		}

		int nextInt() {
			String s = next();
			int res = 0;
			if (s.charAt(0) == '-') {
				for (int i = 1; i < s.length(); i++) {
					res = 10 * res + s.charAt(i) - '0';
				}
				return -res;
			}
			for (int i = 0; i < s.length(); i++) {
				res = 10 * res + s.charAt(i) - '0';
			}
			return res;
		}

		long nextLong() {
			return Long.parseLong(next());
		}

		double nextDouble() {
			return Double.parseDouble(next());
		}

	}

	public static void main(String[] arg) {
		new MainSlow().run();
	}
}
