#include <bits/stdc++.h>
#include "testlib.h"

#include "common.h"

using ll = long long;

void print(const std::vector<std::string>& xs, const std::vector<std::string>& ys) {
    int n = int(xs.size());
    assert(n == int(ys.size()));
    for (int i = 0; i < n; ++i) {
        std::cout << xs[i] << " " << ys[i] << "\n";
    }
}

void print(const std::vector<std::pair<std::string, std::string>>& a) {
    for (const auto& [x, y] : a) {
        std::cout << x << " " << y << "\n";
    }
}

void almostDistinct(int n) {
    int d = opt<int>("d");
    int cntX = rnd.next(n - d, n);
    int cntY = rnd.next(n - d, n);
    auto xs = genStrings(cntX);
    auto ys = genStrings(cntY);
    
    auto ordX = rnd.perm(n);
    auto ordY = rnd.perm(n);
    for (int i = 0; i < n; ++i) {
        std::string x, y;
        if (ordX[i] < cntX) {
            x = xs[ordX[i]];
        } else {
            x = rnd.any(xs);
        }
        if (ordY[i] < cntY) {
            y = ys[ordY[i]];
        } else {
            y = rnd.any(ys);
        }
        std::cout << x << " " << y << "\n";
    }
}

void fewSwaps(int n) {
    std::vector<std::pair<std::string, std::string>> a(n);
    a[0].first = genString();
    a[0].second = genString();
    std::set<std::pair<std::string, std::string>> used;
    used.insert(a[0]);
    for (int i = 1; i < n; ++i) {
        do {
            a[i].first = genString();
            a[i].second = genString();
            if (rnd.next(2)) {
                a[i].first = a[i - 1].first;
            } else {
                a[i].second = a[i - 1].second;
            }
        } while (!used.insert(a[i]).second);
    }
    int swaps = opt<int>("swaps");
    while (swaps--) {
        int i = rnd.next(0, n - 1);
        int j = rnd.next(0, n - 1);
        std::swap(a[i], a[j]);
    }
    print(a);
}

void genTest(int n) {
    std::cout << n << "\n";
    
    auto tmode = opt<std::string>("tmode");
    if (tmode == "almost-distinct") {
        almostDistinct(n);
    } else if (tmode == "few-swaps") {
        fewSwaps(n);
    } else {
        assert(false);
    }
}

int main(int argc, char** argv) {
    registerGen(argc, argv, 1);
    int t = opt<int>("t");

    std::cout << t << "\n";
    auto ns = rnd.partition(t, N, 2);
    for (int n : ns) {
        genTest(n);
    }
    
    return 0;
}
