#include "testlib.h"
#include <iostream>

using namespace std;

int const MAX_N = 2000;
int const MAX_T = 2000;

struct TestCase {
  int n, k, d;
};

int main(int argc, char *argv[]) {
  registerGen(argc, argv, 1);
  int min_n = opt<int>("min-n");
  int max_n = opt<int>("max-n");
  vector<TestCase> test_cases;
  for (int t = 1; t <= MAX_T; t++) {
    int n = rnd.next(min_n, max_n);
    int k = rnd.next(1, n);
    int d = rnd.next(1, MAX_N);
    test_cases.push_back({n, k, d});
  }
  cout << test_cases.size() << endl;
  for (int i = 0; i < test_cases.size(); i++) {
    setTestCase(i);
    const auto &test_case = test_cases[i];
    cout << test_case.n << " " << test_case.k << " " << test_case.d << endl;
  }
  return 0;
}
