from decimal import Decimal, getcontext
getcontext().prec = 100

half = Decimal('0.5')
one = Decimal(1)

dp = []

def precalc():
    n = 2000
    global dp
    dp = [[Decimal(0)] * (n + 1) for i in range(n + 1)]
    dp[1][0] = Decimal(0)
    for i in range(2, n + 1):
        dp[i][0] = dp[i - 1][0] + half
        for j in range(1, n + 1):
            A = one + dp[i - 1][j - 1]
            B = dp[i - 1][j]
            diff = A - B
            dp[i][j] = B + half * (one + diff * diff)

def solve():
    n, k, d = map(int, input().split())
    ans = Decimal(d - 1) * half * Decimal(n) + dp[n][k - 1] + one
    print(f"{ans:.10f}")

precalc()
tests = int(input())
for _ in range(tests):
    solve()
