import java.io.*;
import java.util.ArrayList;
import java.util.List;

public class ReplaceAll {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Invalid command line\nUsage\tjava -jar ReplaceAll.jar <file> <regex> <replacement>");
            System.exit(1);
        }
        
        File file = new File(args[0]);
        if (!file.isFile()) {
            System.err.println("Can't find file\nUsage\tjava -jar ReplaceAll.jar <file> <regex> <replacement>");
            System.exit(1);
        }
        
        List<String> result = new ArrayList<String>(); 

        BufferedReader reader = new BufferedReader(new FileReader(file));
        while (true) {
            String line = reader.readLine();
            if (line == null) {
                break;
            }
            line = line.replaceAll(args[1], args[2]);
            result.add(line);
        }
        reader.close();
        
        PrintWriter writer = new PrintWriter(file);
        for (String line : result) {
            writer.println(line);
        }
        writer.close();
    }
}
