#include "testlib.h"

const pattern any("[^]*");

std::string english_plural(const size_t n) {
    return n == 1 ? "" : "s";
}

int main(int argc, char* argv[]) {
    registerTestlibCmd(argc, argv);
    size_t T = inf.readUnsignedLong(std::numeric_limits<size_t>::min(), std::numeric_limits<size_t>::max(), "t");
    size_t participant_success_t = ouf.readUnsignedLong(std::numeric_limits<size_t>::min(), std::numeric_limits<size_t>::max(), "participant_success_t");
    ouf.readEoln();
    std::string comment = ouf.readLine(any, "comment");
    if (participant_success_t == T)
        quitf(_ok, "%s", std::format("completed all {} test{}: \"{}\"", participant_success_t, english_plural(participant_success_t), comment).c_str());
    quitf(_wa, "%s", std::format("completed only {} test{} out of {}: \"{}\"", participant_success_t, english_plural(participant_success_t), T, comment).c_str());
}
