#include "testlib.h"

using Coordinate = int32_t;
using Area = int32_t;

const Coordinate MIN_X = -1000, MAX_X = 1000;

struct Point2D {
    Coordinate x, y;
    Point2D operator+(const Point2D &other) const {
        return {
            .x = other.x + x,
            .y = other.y + y,
        };
    }
    Point2D operator-(const Point2D &other) const {
        return {
            .x = x - other.x,
            .y = y - other.y,
        };
    }
    bool operator==(const Point2D &other) const {
        return x == other.x && y == other.y;
    }
    Area operator%(const Point2D &other) const {
        return static_cast<Area>(x) * other.y - static_cast<Area>(y) * other.x;
    }
    Area operator*(const Point2D &other) const {
        return static_cast<Area>(x) * other.x + static_cast<Area>(y) * other.y;
    }
};

Point2D read_point(InStream& in, const std::string& point_name) {
    Point2D p;
    p.x = in.readInt(MIN_X, MAX_X, std::format("{}.x", point_name));
    in.readSpace();
    p.y = in.readInt(MIN_X, MAX_X, std::format("{}.y", point_name));
    return p;
}

int main(int argc, char* argv[]) {
    registerValidation(argc, argv);
    // 1. Check that coordinates are fine
    std::array<Point2D, 4> points;
    for (size_t i = 0; i < points.size(); i++) {
        if (i)
            inf.readSpace();
        points[i] = read_point(inf, std::format("p_{}", i + 1));
    }
    inf.readEoln();
    inf.readEof();
    // 2. Check parallelogram
    ensuref(points[0] + points[2] == points[1] + points[3], "the quadrilateral in the input is not a parallelogram");
    // 3. Check strictly counterclockwise direction
    ensuref((points[0] - points[1]) % (points[0] - points[3]) > 0, "the angle p_1--p_0--p_3 is not ccw");
    // 4. Check a right angle
    ensuref((points[0] - points[1]) * (points[0] - points[3]) == 0, "the angle p_1--p_0--p_3 is not right");
}
