#include <algorithm>
#include <iostream>
#include <iomanip>
#include <random>
#include <chrono>
#include <cmath>

#ifndef M_PI_4
const double M_PI_4 = atan(1.);
#endif


struct Point2D {
    int x, y;
    Point2D operator-(const Point2D &p) const {
        return {
            .x = x - p.x,
            .y = y - p.y,
        };
    }
    int operator%(const Point2D &p) const {
        return x * p.y - y * p.x;
    }
};

std::istream& operator>>(std::istream& in, Point2D &p) {
    return in >> p.x >> p.y;
}

int main() {
    std::mt19937 rng(std::chrono::high_resolution_clock::now().time_since_epoch().count());
    std::array<Point2D, 4> points;
    for (Point2D &p : points)
        std::cin >> p;
    std::shuffle(points.begin(), points.end(), rng);
    std::cout << std::fixed << std::setprecision(30) << abs((points[1] - points[0]) % (points[3] - points[0])) * M_PI_4 << std::endl;
}
