// Author: Ivan Kazmenko (gassa@mail.ru)
// Validator for problem "hex-operations"
module validate;
import std.algorithm;
import std.conv;
import std.exception;
import std.math;
import std.string;
import testlib;

immutable int minN =       2;
immutable int maxN =     500;
immutable int minL =       1;
immutable int maxL = 250_000;
immutable int maxT = 1 << 23;
immutable int sizeLF = 2;

void main (string [] args)
{
	initTestlib !(TestlibRole.validator) (args);

	auto n = inFile.read !(int) (minN, maxN);
	inFile.skip ("\n");
	int total = n.text.length.to !(int) + sizeLF;
	enforce (total <= maxT);

	foreach (row; -n + 1..n)
	{
		auto temp = inFile.readln;
		total += temp.length + sizeLF;
		enforce (total <= maxT);

		auto width = n * 2 - 1 - abs (row);
		auto line = temp.split;
		enforce (line.length == width);
		foreach (ref part; line)
		{
			enforce (part.length <= 2);
			enforce (part.all !(c => '0' <= c && c <= '9'));
			enforce (part.length == 1 || part[0] != '0');
		}
	}

	auto cmd = inFile.readln;
	total += cmd.length.to !(int) + sizeLF;
	enforce (minL <= cmd.length && cmd.length <= maxL);
	enforce (cmd.all !(c => "LRT".canFind (c)));

	enforce (total <= maxT);
	inFile.checkEof ();
}
