#include "testlib.h"
#include <bits/stdc++.h>

using ll = long long;

const int max_coef = int(1e9);

struct point
{
    int x, y;

    point () : x(0), y(0) {}
    point (const int x_, const int y_) : x(x_), y(y_) {}

    point operator - (const point &o) const
    {
        return point(x - o.x, y - o.y);
    }

    ll operator * (const point &o) const
    {
        return ll(x) * o.x + ll(y) * o.y;
    }

    ll sqlen() const
    {
        return ll(x) * x + ll(y) * y;
    }
};

struct line
{
    int a, b, c;

    bool passes (const point &p) const
    {
        return ll(a) * p.x + ll(b) * p.y + ll(c) == 0LL;
    }

    point direction () const
    {
        return point(-b, a);
    }
};

/// This checker uses some knowledge about the problem to make the checking process easier.
void read_ans (InStream &stream, const std::vector<point> &pts)
{
    std::vector<line> borders(2);

    for (int i = 0; i < 2; i++)
    {
        borders[i].a = stream.readInt(-max_coef, +max_coef, format("a[%d]", i).c_str());
        borders[i].b = stream.readInt(-max_coef, +max_coef, format("b[%d]", i).c_str());
        borders[i].c = stream.readInt(-max_coef, +max_coef, format("c[%d]", i).c_str());
        if (borders[i].a == 0 && borders[i].b == 0)
            stream.quitf(_wa, "not a line: a[%d] = 0 and b[%d] = 0", i, i);
    }

    const int n = int(pts.size());

    std::vector<int> who_on(2, -1);

    /// The optimal lines pass through exactly one point each.
    for (int i = 0; i < 2; i++)
    for (int j = 0; j < n; j++)
    if (borders[i].passes(pts[j]))
        who_on[i] = j;

    /// If the line does not pass through
    for (int i = 0; i < 2; i++)
    if (who_on[i] == -1)
        stream.quitf(_wa, "line %d does not pass through any point", i);

    ll max_sq = 0;
    for (int i = 0; i < n; i++)
    for (int j = i + 1; j < n; j++)
        max_sq = std::max(max_sq, (pts[j] - pts[i]).sqlen());

    /// Again, the optimal lines pass through exactly one point each.
    const point seg = pts[who_on[1]] - pts[who_on[0]];
    const ll my_sq = seg.sqlen();
    assert(max_sq <= max_coef && my_sq <= max_coef);

    /// If there are multiple pairs that achieve the largest distance,
    /// any of them sufficies. Moreover, both squares fit into an int.
    if (my_sq < max_sq)
        stream.quitf(_wa, "points are not far enough: max_sq = %d, my_sq = %d",
                     int(max_sq), int(my_sq));

    /// Finally, we need to check that the lines are perpendicular to the
    /// segment between the points. Must be careful, the product may not
    /// fit into an int.
    for (int i = 0; i < 2; i++)
    if (borders[i].direction() * seg != 0LL)
        stream.quitf(_wa, "line %d is not perpendicular to seg = (%d, %d)", i, seg.x, seg.y);
        
    stream.seekEof();
    stream.readEof();
}

int main (int argc, char* argv[])
{
    registerTestlibCmd(argc, argv);

    const int n = inf.readInt();
    std::vector<point> pts(n);
    for (int i = 0; i < n; i++)
    {
        pts[i].x = inf.readInt();
        pts[i].y = inf.readInt();
    }

    read_ans(ans, pts);
    read_ans(ouf, pts);
    quitf(_ok, "both the participant and the jury do the correct things");
}
