#include "testlib.h"
#include <bits/stdc++.h>
using namespace std;

const int max_coord = int(1e4);

int main (int argc, char *argv[])
{
    registerGen(argc, argv, 1);

    const int n = opt<int>("n");
    const int k = opt<int>("k");
    const bool parallel = opt<bool>("parallel");
    ensure(k >= 1);

    set<pair<int, int>> pts;

    vector<int> cnt(k);

    if (k > 1)
    {
        for (int i = 0; i < n; i++)
            cnt[rnd.next(0, k - 1)]++;
    }
    else
        cnt[0] = n;


    for (int iter = 0; iter < k; iter++)
    {
        static int shift_x = 0, shift_y = 0;

        if (!parallel)
        {
            shift_x = 0;
            shift_y = 0;
        }

        while (shift_x == 0 && shift_y == 0)
        {
            shift_x = rnd.next(-3, +3);
            shift_y = rnd.next(-3, +3);
        }

        const int x = rnd.next(max_coord / 10 * 4, max_coord / 10 * 6);
        const int y = rnd.next(max_coord / 10 * 4, max_coord / 10 * 6);

        vector<pair<int, int>> who;
        for (int i = -max_coord; i <= +max_coord; i++)
        {
            const int nx = x + shift_x * i;
            const int ny = y + shift_y * i;
            if (0 <= min(nx, ny) && max(nx, ny) <= max_coord)
                who.emplace_back(nx, ny);
        }

        shuffle(who.begin(), who.end());
        for (int i = 0; i < cnt[iter]; i++)
            pts.insert(who[i]);
    }

    ensure(int(pts.size()) == n);

    vector<pair<int, int>> v(pts.begin(), pts.end());
    shuffle(v.begin(), v.end());

    cout << n << endl;
    for (int i = 0; i < n; i++)
        cout << v[i].first << ' ' << v[i].second << "\n";
}
