#include <iostream>

int64_t decipher(const char c) {
    return c - 'A';
}

bool find_ans(const std::string& score) {
    int64_t left = 10, right = -10, last = 3;
    for (char c : score) {
        last += (decipher(c) - last % 7 + 10) % 7 - 3;
        left = std::min(left, last);
        right = std::max(right, last);
        if (right - left + (left % 7 + 7) % 7 >= 52)
            return false;
    }
    return true;
}

bool solve_test(size_t test_index) {
    std::string score;
    if (!(std::cin >> score))
        return false;
    bool ans = find_ans(score);
    std::cout << (ans ? "YES" : "NO") << '\n';
    return true;
}

void solve_tests() {
    size_t t;
    std::cin >> t;
    for (size_t i = 0; i < t; i++)
        if (!solve_test(i))
            return;
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);
    solve_tests();
}
