// Author: Ivan Kazmenko (gassa@mail.ru)
// Standard checker: compare sequences of tokens as int64 ignoring whitespace
module check;
import std.algorithm;
import std.conv;
import std.format;
import std.range;
import std.string;
import testlib;

immutable int tokensToReport = 5;

void main (string [] args)
{
	initTestlib !(TestlibRole.checker) (args);

	auto outTokens = outFile.byToken;
	auto ansTokens = ansFile.byToken;
	int tokenNumber = 0;
	string [] reportTokens;
	foreach (outToken, ansToken; zip (outTokens, ansTokens))
	{
		tokenNumber += 1;

		long outInt64;
		try
		{
			outInt64 = outToken.to !(long);
		}
		catch (Exception e)
		{
			quit (ExitCode.wa, "token ", tokenNumber, ": `",
			    outToken.shorten, "' is not an int64");
		}

		long ansInt64;
		try
		{
			ansInt64 = ansToken.to !(long);
		}
		catch (Exception e)
		{
			quit (ExitCode.fail, "token ", tokenNumber, ": `",
			    ansToken.shorten, "' is not an int64");
		}

		if (outInt64 != ansInt64)
		{
			quit (ExitCode.wa, "token ", tokenNumber, ": `",
			    outToken.shorten, "' instead of `",
			    ansToken.shorten, "'");
		}
		if (reportTokens.length < tokensToReport)
		{
			reportTokens ~= outToken.shorten;
		}
	}
	if (!outTokens.empty)
	{
		quit (ExitCode.pe, "extra tokens: more than ", tokenNumber);
	}
	if (!ansTokens.empty)
	{
		quit (ExitCode.pe, "not enough tokens: ", tokenNumber);
	}
	outFile.checkEof ();
	ansFile.checkEof ();
	auto message = format ("%s token%s: %-(%s, %)%s",
	    tokenNumber, tokenNumber == 1 ? "" : "s", reportTokens,
	    tokenNumber > reportTokens.length ? "..." : "");
	quit (ExitCode.ok, message);
}
