import qualified Data.ByteString.Char8 as C
import Data.Word
import Data.Bits
import Control.Monad
import Data.Int

ri :: C.ByteString -> Int
ri s = r
  where Just (r, _) = C.readInt s

next :: Int -> Int
next s = fromIntegral $ (s * 618023 + 1) `mod` 999983
  where s' = fromIntegral s :: Int64

rec :: Int -> Int -> Int -> Integer -> Integer -> Int
rec 0 ans _ _ _ = ans
rec n ans s bs x 
  | testBit x i = rec (pred n) ans s' bs x
  | True = let bs' = setBit bs i in rec (pred n) (succ ans) s' bs' (xor (shiftR bs' s') x)
  where
    s' = next s
    i = 999982 - s'

main = do
  cts <- C.getContents
  let (n:s:[]) = map ri $ C.words cts
  print (rec n 0 s 0 0)
