// Author: Ivan Kazmenko (gassa@mail.ru)
#include <bits/stdc++.h>
using namespace std;

int constexpr a =       1;
int constexpr p = 618'023;
int constexpr m = 999'983;

using Base = uint64_t;
int constexpr baseBytes = sizeof (Base);
int constexpr baseBits = baseBytes * 8;
int constexpr baseAnd = baseBits - 1;
int constexpr baseLog = __builtin_ctz (baseBits);
int constexpr len = (m + baseBits - 1) / baseBits + 1;

struct BitSet
{
	array <Base, len> a = {};

	bool operator [] (int pos) const
	{
		return (a[pos >> baseLog] >> (pos & baseAnd)) & 1;
	}

	void assign (bool val, int pos)
	{
		if (pos < 0)
   		{
   			return;
   		}
		auto shift = pos & baseAnd;
		auto mask = Base (1) << shift;
		a[pos >> baseLog] = (a[pos >> baseLog] & ~mask) ^
		    (Base (val) << shift);
	}
};

int solve (int n, int s)
{
	int total = 0;
	BitSet fwd;
	array <BitSet, baseBits> rev;
	for (int i = 0; i < n; i++)
	{
		s = int ((int64_t (s) * p + a) % m);
		int cur = 0;
		int lim = s / 2 + 1;
		auto start = m - s;
		auto startDiv = start >> baseLog;
		auto startMod = start & baseAnd;
		auto startAligned = startDiv << baseLog;
		auto full = lim / baseBits;
		for (int y = 0; y < full; y++)
		{
			cur += __builtin_popcountll (fwd.a[y] &
			    rev[startMod].a[startDiv + y]);
		}
		for (int x = full * baseBits; x < lim; x++)
		{
			cur += fwd[x] & rev[startMod][startAligned + x];
		}
		if (!(cur & 1))
		{
			fwd.assign (true, s);
			for (int b = 0; b < baseBits; b++)
			{
				rev[b].assign (true, m - s - b);
		        }
			total += 1;
		}
	}
	return total;
}

int main ()
{
	int n, s;
	while (cin >> n >> s)
	{
		cout << solve (n, s) << endl;
	}
	return 0;
}
