// Author: Ivan Kazmenko (gassa@mail.ru)
module solution;
import core.bitop;
import std;

immutable int a =       1;
immutable int p = 618_023;
immutable int m = 999_983;

alias Base = ulong;
immutable int baseBytes = Base.sizeof;
immutable int baseBits = baseBytes * 8;
immutable int baseAnd = baseBits - 1;
immutable int baseLog = bsr (baseBits);
immutable int len = (m + baseBits - 1) / baseBits + 1;

struct BitSet
{
	Base [len] a;

	bool opIndex (int pos) const
	{
		return (a[pos >> baseLog] >> (pos & baseAnd)) & 1;
	}

	void opIndexAssign (bool val, int pos)
	{
		if (pos < 0)
   		{
   			return;
   		}
		auto shift = pos & baseAnd;
		auto mask = Base (1) << shift;
		a[pos >> baseLog] = (a[pos >> baseLog] & ~mask) ^
		    (Base (val) << shift);
	}
}

int solve (int n, int s)
{
	int total = 0;
	BitSet fwd;
	BitSet [baseBits] rev;
	foreach (i; 0..n)
	{
		s = (cast (long) (s) * p + a) % m;
		debug {writeln (s);}
		int cur = 0;
		int lim = s / 2 + 1;
		auto start = m - s;
		auto startDiv = start >> baseLog;
		auto startMod = start & baseAnd;
		auto startAligned = startDiv << baseLog;
		auto full = lim / baseBits;
		for (int y = 0; y < full; y++)
		{
			cur += popcnt (fwd.a[y] & rev[startMod].a[startDiv + y]);
		}
		for (int x = full * baseBits; x < lim; x++)
		{
			cur += fwd[x] & rev[startMod][startAligned + x];
		}
		if (!(cur & 1))
		{
			fwd[s] = true;
			foreach (b; 0..baseBits)
			{
				rev[b][m - s - b] = true;
		        }
			total += 1;
		}
	}
	return total;
}

void main ()
{
	int n, s;
	while (readf !(" %s %s") (n, s) > 0)
	{
		writeln (solve (n, s));
	}
}
