pub use self::template::*;
use std::io::{stdin, stdout, BufWriter, Write};

fn solve_test(_scan: &mut impl Scanner, cout: &mut impl Write) -> Result<(), std::io::Error> {
    let args: Vec<String> = std::env::args().collect();

    assert_eq!(args.len(), 3);

    let n: u64 = args[1].parse().unwrap();
    let bnd: u64 = args[2].parse().unwrap();

    writeln!(cout, "0")?;
    writeln!(cout, "{n}")?;
    writeln!(
        cout,
        "{}",
        (0..n)
            .map(|i| (i % bnd + 1).to_string())
            .collect::<Vec<_>>()
            .join(" ")
    )
}

pub fn solve(scan: &mut impl Scanner, cout: &mut impl Write) {
    let t = 1;

    for _test in 0..t {
        solve_test(scan, cout).unwrap();
    }

    cout.flush().unwrap();
}

#[cfg(feature = "generate")]
pub fn generate(_test: usize, cout: &mut impl Write) -> Result<(), std::io::Error> {
    cout.flush()
}

#[allow(dead_code)]
fn main() {
    solve(
        &mut IOScanner::new(stdin().lock()),
        &mut BufWriter::new(stdout().lock()),
    );
}

pub mod template {
    use std::io::BufRead;
    use std::str::FromStr;

    pub trait Scanner {
        fn checked_next_line(&mut self) -> Option<String>;

        fn checked_next<T: FromStr>(&mut self) -> Option<T>;

        #[allow(dead_code)]
        fn next<T: FromStr>(&mut self) -> T;

        fn seek(&mut self) -> bool;
    }

    pub struct IOScanner<ReadType: BufRead> {
        read: ReadType,
        buffer: Vec<String>,
    }

    impl<ReadType: BufRead> Scanner for IOScanner<ReadType> {
        fn checked_next_line(&mut self) -> Option<String> {
            self.buffer.clear();
            let mut input = String::new();
            if self.read.read_line(&mut input).expect("Failed read") > 0 {
                Some(input)
            } else {
                None
            }
        }

        fn checked_next<T: FromStr>(&mut self) -> Option<T> {
            loop {
                if let Some(token) = self.buffer.pop() {
                    return Some(token.parse().ok().expect("Failed parse"));
                }
                if let Some(input) = self.checked_next_line() {
                    self.buffer = input.split_whitespace().rev().map(String::from).collect();
                } else {
                    return None;
                }
            }
        }

        fn next<T: FromStr>(&mut self) -> T {
            self.checked_next().expect("Read after EOF")
        }

        fn seek(&mut self) -> bool {
            let mut input = String::new();

            while let Ok(cnt) = self.read.read_line(&mut input) {
                if cnt == 0 {
                    break;
                }
                let line = input.trim();
                if !line.is_empty() && line.matches("=").count() == line.len() {
                    return true;
                }
                input.clear();
            }

            false
        }
    }

    impl<ReadType: BufRead> IOScanner<ReadType> {
        pub fn new(read: ReadType) -> IOScanner<ReadType> {
            IOScanner {
                read,
                buffer: Vec::<String>::default(),
            }
        }
    }
}
