import sys
input = sys.stdin.readline

n = int(input())
hex_rows = []
for _ in range(2*n-1):
    hex_rows.append(list(map(int, input().split())))
ops = input().strip()

# Step 1: Compute net operations
rot = 0
flip = 0
for op in ops:
    if op == 'R':
        rot += 1
    elif op == 'L':
        rot -= 1
    else:
        flip ^= 1
rot %= 6

# Step 2: Convert hex to axial coordinates
coord_map = {}
for i, row in enumerate(hex_rows):
    # Determine the offset of the first cell in this row
    if i < n:
        row_len = n + i
        start_col = 0
    else:
        row_len = 3*n - 2 - i
        start_col = 0
    for j, val in enumerate(row):
        q = j - min(i, n-1)  # axial coordinate q
        r = i                  # axial coordinate r
        coord_map[(q, r)] = val

# Step 3: Apply rotation and flip transformations
def transform(q, r):
    # Apply rotation
    for _ in range(rot):
        q, r = -r, q + r
    # Apply vertical reflection if needed
    if flip:
        q = -q
    return (q, r)

new_map = {}
for (q, r), val in coord_map.items():
    new_map[transform(q, r)] = val

# Step 4: Convert back to row/column structure
result_rows = [[] for _ in range(2*n-1)]
# Compute min/max r to align rows
min_r = min(r for (q, r) in new_map)
max_r = max(r for (q, r) in new_map)

for (q, r), val in new_map.items():
    row_idx = r - min_r
    result_rows[row_idx].append((q, val))

# Sort each row by q and extract values
for i in range(len(result_rows)):
    row = result_rows[i]
    row.sort()  # sort by q
    result_rows[i] = [v for _, v in row]

# Step 5: Print result
for row in result_rows:
    print(" ".join(map(str, row)))
