from math import gcd

def solve():
    n = int(input())
    po = [tuple(map(int, input().split())) for _ in range(n)]
    vectors = []
    for i in range(n):
        for j in range(i + 1, n):
            dx = po[j][0] - po[i][0]
            dy = po[j][1] - po[i][1]
            if dx == 0 and dy == 0:
                continue

    
            g = gcd(abs(dx), abs(dy))
            dx //= g
            dy //= g
            if dx < 0 or (dx == 0 and dy < 0):
                dx, dy = -dx, -dy

            vectors.append((dx, dy))
    vectors = list(set(vectors))

    best = -1
    best_line1 = None
    best_line2 = None

    for dx, dy in vectors:
        a, b = dy, -dx
        projs = [a * x + b * y for x, y in po]
        min_val = min(projs)
        max_val = max(projs)

        dist_sq = (max_val - min_val)**2 / (a*a + b*b)

        if dist_sq > best:
            best = dist_sq
            best_line1 = (a, b, -min_val)
            best_line2 = (a, b, -max_val)

    print(*best_line1)
    print(*best_line2)

solve()
