
from math import gcd

def solve():
    n = int(input())
    po = [tuple(map(int, input().split())) for _ in range(n)]
    normals = set()

    for i in range(n):
        for j in range(i + 1, n):
            dx = po[j][0] - po[i][0]
            dy = po[j][1] - po[i][1]
            a, b = dy, -dx
            if a == 0 and b == 0:
                continue
            g = gcd(abs(a), abs(b))
            a //= g
            b //= g
            if a < 0 or (a == 0 and b < 0):
                a, b = -a, -b

            normals.add((a, b))

    best = -1
    best_line1 = None
    best_line2 = None
    for a, b in normals:

        projs = [a * x + b * y for x, y in po]
        min_val = min(projs)
        max_val = max(projs)

        dist_sq = (max_val - min_val)**2 / (a*a + b*b)

        if dist_sq > best:
            best = dist_sq
            best_line1 = (a, b, -min_val)
            best_line2 = (a, b, -max_val)

    print(*best_line1)
    print(*best_line2)

solve()
