n = int(input().strip())

grid = [list(map(int, input().split())) for _ in range(2 * n - 1)]
commands = input()

r = n - 1
cells = []
pos_map = {}

for z in range(-r, r + 1):
    x_min = max(-r, -z - r)
    x_max = min(r, -z + r)
    for x in range(x_min, x_max + 1):
        y = -x - z
        pos_map[(x, y, z)] = len(cells)
        cells.append((x, y, z))

values = [num for row in grid for num in row]
row_sizes = [len(row) for row in grid]
total = len(cells)

perm = [0, 1, 2]
sign = [1, 1, 1]

ops_data = {
    'R': ([2, 0, 1], [-1, -1, -1]),
    'L': ([1, 2, 0], [-1, -1, -1]),
    'T': ([1, 0, 2], [1, 1, 1])
}

for op in commands:
    p2, s2 = ops_data[op]
    new_p, new_s = [0] * 3, [0] * 3
    for i in range(3):
        j = p2[i]
        new_p[i] = perm[j]
        new_s[i] = s2[i] * sign[j]
    perm, sign = new_p, new_s

res = [0] * total
for idx, (x, y, z) in enumerate(cells):
    v = (x, y, z)
    nx = v[perm[0]] * sign[0]
    ny = v[perm[1]] * sign[1]
    nz = v[perm[2]] * sign[2]
    res[pos_map[(nx, ny, nz)]] = values[idx]

ptr = 0
for sz in row_sizes:
    print(*res[ptr:ptr + sz])
    ptr += sz