import jdk.dynalink.Operation;

import java.util.Scanner;
import java.util.concurrent.Callable;

import static java.lang.System.exit;
import static java.lang.System.setOut;

public class Main {
    static String piano = "";
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);


        int amount = scanner.nextInt();

        for (int i = 0; i < amount; i++) {
            String str = scanner.next();

            if (str.length() == 1) {
                System.out.println("YES");
                continue;
            }
            int minIndex = 100;
            int maxIndex = 0;


            int curIndex = 0;
            char curSimv = str.charAt(0);


            for (int j = 1; j < str.length(); j++) {
                char newSimv = str.charAt(j);

                curIndex += check(curSimv, newSimv);

                minIndex = Math.min(minIndex, curIndex);
                maxIndex = Math.max(maxIndex, curIndex);


                if (curIndex == -10000) {
                    exit(2);
                }
                curSimv = newSimv;
            }

            if (minIndex > 0) {
                minIndex = 0;
            }

            boolean isCan = false;
            int numOct = 7;
            int numSimv = charToInt(str.charAt(0));
            if (str.charAt(0) == 'A' || str.charAt(0) == 'B' || str.charAt(0) == 'C') {
                numOct++;
            }

            for (int k = 0; k < numOct; k++) {
                if ((numSimv + k*7) - minIndex >= 0 && (numSimv + k*7) + maxIndex < 52) {
                    isCan = true;
                }
            }

            if (isCan) {
                System.out.println("YES");
            } else {
                System.out.println("NO");
            }

        }
    }

    public static int check(char curSimv, char newSimv) {
        if (curSimv == newSimv) {
            return 0;
        }

        boolean isToRight = toRight(curSimv, newSimv);

        Operationable op = (int num1, int num2) ->  num1 + 7 - num2;
        ;

        if (isToRight) {
            op = (int num1, int num2) -> num1 + num2;
        }


        for (int i = 1; i < 4; i++) {
            if (intToChar(op.execute(charToInt(curSimv),i)) == newSimv) {
                if (isToRight) {
                    return +i;
                } else {
                    return -i;
                }
            }
        }
        return -10000;
    }

    public static boolean toRight(char ch1, char ch2) {
        int num1 = charToInt(ch1) - 1;
        int num2 = charToInt(ch2) - 1;

        int lenRightStep = (num2 - num1 + 7) % 7;

        return lenRightStep > 0 && lenRightStep <= 3;
    }

    public static int charToInt(char c) {
        switch (c) {
            case 'A':
                return 0;
            case 'B':
                return 1;
            case 'C':
                return 2;
            case 'D':
                return 3;
            case 'E':
                return 4;
            case 'F':
                return 5;
            case 'G':
                return 6;
            default :
                System.out.println("Error in charToInt: " + String.valueOf(c));
                return -1;
        }
    }

    public static char intToChar(int num) {
        num = num % 7;

        switch (num) {
            case 0:
                return 'A';
            case 1:
                return 'B';
            case 2:
                return 'C';
            case 3:
                return 'D';
            case 4:
                return 'E';
            case 5:
                return 'F';
            case 6:
                return 'G';
            default:
                System.out.println("Error in intToChar: " + String.valueOf(num));
                return ' ';
        }
    }
}
interface Operationable {
    int execute(int x, int y);
}