#include <bits/stdc++.h>
using namespace std;
using ll = long long;

struct vec {
  int x, y, z;
};

bool operator==(const vec &a, const vec &b) {
  return a.x == b.x && a.y == b.y && a.z == b.z;
}

struct Hasher {
  std::size_t operator()(const vec &v) const {
    return std::hash<ll>()(((ll)v.x + 512) | ((ll)(v.y + 512) << 20) |
                           ((ll)(v.z + 512) << 40));
  }
};

void mul(int a[3][3], int b[3][3], int c[3][3]) {
  int ans[3][3]{};
  for (int i = 0; i < 3; ++i)
    for (int k = 0; k < 3; ++k)
      for (int j = 0; j < 3; ++j)
        ans[i][j] += a[i][k] * b[k][j];
  for (int i = 0; i < 3; ++i)
    for (int j = 0; j < 3; ++j)
      c[i][j] = ans[i][j];
}

void mul2(int m[3][3], const vec &in, vec &out) {
  out.x = m[0][0] * in.x + m[0][1] * in.y + m[0][2] * in.z;
  out.y = m[1][0] * in.x + m[1][1] * in.y + m[1][2] * in.z;
  out.z = m[2][0] * in.x + m[2][1] * in.y + m[2][2] * in.z;
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);
  cout.tie(nullptr);
  int n;
  cin >> n;
  vector<vector<int>> table(2 * n - 1);
  for (int i = 0; i < 2 * n - 1; ++i) {
    int len;
    if (i < n)
      len = n + i;
    else
      len = n + (2 * n - 2 - i);
    table[i].resize(len);
    for (int j = 0; j < len; ++j)
      cin >> table[i][j];
  }
  string ops;
  cin >> ops;

  int R[3][3]{{0, 0, -1}, {-1, 0, 0}, {0, -1, 0}};
  int L[3][3]{{0, -1, 0}, {0, 0, -1}, {-1, 0, 0}};
  int T[3][3]{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}};
  int M[3][3]{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}};
  int tmp[3][3]{};
  for (char c : ops) {
    switch (c) {
    case 'R':
      mul(R, M, tmp);
      break;
    case 'L':
      mul(L, M, tmp);
      break;
    case 'T':
      mul(T, M, tmp);
      break;
    }
    for (int i = 0; i < 3; ++i)
      for (int j = 0; j < 3; ++j)
        M[i][j] = tmp[i][j];
  }
  unordered_map<vec, int, Hasher> mp;
  mp.reserve(3 * n * n);
  int rad = n - 1;
  for (int i = 0; i < 2 * n - 1; ++i) {
    int z = i - rad, x0 = max(-rad, -z - rad);
    for (int j = 0; j < table[i].size(); ++j) {
      int x = x0 + j, y = -x - z;
      vec pos;
      mul2(M, vec{x, y, z}, pos);
      mp[pos] = table[i][j];
    }
  }
  ostringstream out;
  for (int i = 0; i < 2 * n - 1; ++i) {
    int z = i - rad;
    int x0 = max(-rad, -z - rad);
    for (int j = 0; j < table[i].size(); ++j) {
      int x = x0 + j, y = -x - z;
      out << mp[vec{x, y, z}] << ' ';
    }
    out << '\n';
  }
  cout << out.str();
  return 0;
}