import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class Main {
    private static final String PIANO = "ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGAB";

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        int t = Integer.parseInt(scanner.nextLine().trim());

        StringBuilder result = new StringBuilder();
        for (int i = 0; i < t; i++) {
            String melody = scanner.nextLine();
            if (canPlay(melody)) {
                result.append("Yes\n");
            } else {
                result.append("No\n");
            }
        }
        System.out.print(result);
        scanner.close();
    }

    private static boolean canPlay(String melody) {
        if (melody.length() == 1) return true;

        char[] notes = melody.toCharArray();

        // Множество возможных позиций для текущей ноты
        Set<Integer> currentPositions = new HashSet<>();

        // Инициализация: все позиции первой ноты
        for (int i = 0; i < PIANO.length(); i++) {
            if (PIANO.charAt(i) == notes[0]) {
                currentPositions.add(i);
            }
        }

        for (int i = 1; i < notes.length; i++) {
            if (currentPositions.isEmpty()) return false;

            Set<Integer> nextPositions = new HashSet<>();
            char targetNote = notes[i];

            for (int pos : currentPositions) {
                // Проверяем все возможные переходы (±0, ±1, ±2, ±3)
                for (int delta = -3; delta <= 3; delta++) {
                    int newPos = pos + delta;
                    if (newPos >= 0 && newPos < PIANO.length() &&
                            PIANO.charAt(newPos) == targetNote) {
                        nextPositions.add(newPos);
                    }
                }
            }

            currentPositions = nextPositions;
        }

        return !currentPositions.isEmpty();
    }
}