import sys
from collections import deque


def first_run(n, a):
    rev = [[] for _ in range(n)]
    for i in range(n):
        rev[a[i] - 1].append(i)

    visited = [False] * n
    q = deque([0])
    visited[0] = True
    while q:
        u = q.popleft()
        for v in rev[u]:
            if not visited[v]:
                visited[v] = True
                q.append(v)

    min_v = n + 1
    for i in range(n):
        if not visited[i]:
            min_v = min(min_v, i + 1)
    print(min_v)


def second_run(p, n, b):
    n_players = n + 1
    p0 = p - 1
    next_arr = [-1] * n_players
    idx = (p0 + 1) % n_players
    for val in b:
        next_arr[idx] = val - 1
        idx = (idx + 1) % n_players

    for x in range(1, n_players + 1):
        next_arr[p0] = x - 1
        visited = [False] * n_players
        cur = p0
        cycle_nodes = []
        while not visited[cur]:
            visited[cur] = True
            cycle_nodes.append(cur)
            cur = next_arr[cur]
        if min(cycle_nodes) == p0:
            print(x)
            return


def main():
    data = sys.stdin.read().split()
    i = 0
    while i < len(data):
        launch_type = int(data[i])
        i += 1
        n = int(data[i])
        i += 1
        arr = [int(x) for x in data[i:i + n]]
        i += n
        if launch_type == 0:
            first_run(n, arr)
        else:
            second_run(launch_type, n, arr)


if __name__ == "__main__":
    main()