﻿#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

struct Point {
    int x, y;
    Point() {}
    Point(int x, int y) : x(x), y(y) {}
    bool operator < (const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
};

int cross(const Point& O, const Point& A, const Point& B) {
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}

vector<Point> convexHull(vector<Point> P) {
    int n = P.size();
    if (n <= 1) return P;
    sort(P.begin(), P.end());
    vector<Point> hull;
    for (int i = 0; i < n; i++) {
        while (hull.size() >= 2 && cross(hull[hull.size() - 2], hull.back(), P[i]) <= 0)
            hull.pop_back();
        hull.push_back(P[i]);
    }
    int lower_hull_size = hull.size();
    for (int i = n - 2; i >= 0; i--) {
        while (hull.size() > lower_hull_size && cross(hull[hull.size() - 2], hull.back(), P[i]) <= 0)
            hull.pop_back();
        hull.push_back(P[i]);
    }
    hull.pop_back();
    return hull;
}

long long dist2(const Point& a, const Point& b) {
    return (long long)(a.x - b.x) * (a.x - b.x) + (long long)(a.y - b.y) * (a.y - b.y);
}

int main() {
    int n;
    cin >> n;
    vector<Point> points;
    for (int i = 0; i < n; i++) {
        int x, y;
        cin >> x >> y;
        points.push_back(Point(x, y));
    }

    vector<Point> hull = convexHull(points);
    int m = hull.size();

    long long max_d2 = 0;
    int i0 = 0, j0 = 0;

    for (int i = 0; i < m; i++) {
        for (int j = i + 1; j < m; j++) {
            long long d2 = dist2(hull[i], hull[j]);
            if (d2 > max_d2) {
                max_d2 = d2;
                i0 = i;
                j0 = j;
            }
        }
    }

    Point P = hull[i0];
    Point Q = hull[j0];

    int a = Q.x - P.x;
    int b = Q.y - P.y;
    int c1 = -(a * P.x + b * P.y);
    int c2 = -(a * Q.x + b * Q.y);

    cout << a << " " << b << " " << c1 << endl;
    cout << a << " " << b << " " << c2 << endl;

    return 0;
}