﻿#include <stdio.h>
#include <iostream>

typedef __uint128_t u128;

u128 read_u128() {
    u128 n = 0;
    int c;

    while ((c = getchar()) < '0' || c > '9');

    n = c - '0';

    while ((c = getchar()) >= '0' && c <= '9') {
        n = n * 10 + (c - '0');
    }

    return n;
}

void print_u128(u128 n) {
    if (n == 0) {
        putchar('0');
        return;
    }
    char buf[40];
    int i = 0;
    while (n > 0) {
        buf[i++] = (n % 10) + '0';
        n /= 10;
    }
    for (int j = i - 1; j >= 0; --j) {
        putchar(buf[j]);
    }
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int t;
    scanf("%d", &t);

    for (int i = 0; i < t; ++i) {
        u128 x = read_u128();

        while (x > 1) {
            puts("collatz");

            fflush(stdout);

            x = read_u128();

            if (x == 0) {
                return 0;
            }
        }
    }
    return 0;
}