﻿#include <iostream>
#include <string>

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int t;
    std::cin >> t;

    for (int i = 0; i < t; ++i) {
        std::string x;
        std::cin >> x;

        while (x != "1") {
            if (x == "0") {
                return 0;
            }

            char last_digit = x.back();

            if (last_digit == '0' || last_digit == '2' || last_digit == '4' || last_digit == '6' || last_digit == '8') {
                std::cout << "collatz\n";
            }
            else {
                int last_two_digits = 0;
                int len = x.length();

                if (len >= 2) {
                    last_two_digits = (x[len - 2] - '0') * 10 + (last_digit - '0');
                }
                else {
                    last_two_digits = (last_digit - '0');
                }

                int mod4 = last_two_digits % 4;
                if (mod4 == 1) {
                    std::cout << "collatz\n";
                }
                else {
                    std::cout << "random\n";
                }
            }
            std::cout.flush();
            std::cin >> x;
        }
    }

    return 0;
}