#include <iostream>
#include <vector>
using namespace std;

const long long MOD = 1000000007;

long long power(long long base, long long exp) {
    long long res = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp & 1) res = (res * base) % MOD;
        base = (base * base) % MOD;
        exp >>= 1;
    }
    return res;
}

long long modInverse(long long a) {
    return power(a, MOD - 2);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    while (t--) {
        long long p, m;
        cin >> p >> m;

        long long n = 2 * p + m;
        long long ans = 1;
        long long P = 1;

        for (int k = 1; k <= min(n, p + m + 1); ++k) {

            long long expected_open_pairs = (k - 1) % MOD;
            expected_open_pairs = expected_open_pairs * (2 * p) % MOD;
            expected_open_pairs = expected_open_pairs * modInverse(n) % MOD;

            long long safe = (n - (k - 1) - expected_open_pairs) % MOD;
            if (safe < 0) safe += MOD;

            long long denom = n - k + 1;
            if (denom <= 0) break;

            P = P * safe % MOD;
            P = P * modInverse(denom) % MOD;

            ans = (ans + P) % MOD;
        }

        cout << ans << '\n';
    }

    return 0;
}