﻿#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>

const int MAX_VAL = 999983;
const int MAX_SUM = 2 * MAX_VAL;

const int MAX_FFT_SIZE = 1 << 21;

const int MOD1 = 998244353;
const int ROOT1 = 3;

const int MOD2 = 1004535809;
const int ROOT2 = 3;

long long power(long long base, long long exp, long long mod) {
    long long res = 1;
    base %= mod;
    while (exp > 0) {
        if (exp % 2 == 1) res = (res * base) % mod;
        base = (base * base) % mod;
        exp /= 2;
    }
    return res;
}

long long modInverse(long long n, long long mod) {
    return power(n, mod - 2, mod);
}

void ntt(std::vector<long long>& a, bool invert, int mod, int root) {
    int n = a.size();
    for (int i = 1, j = 0; i < n; i++) {
        int bit = n >> 1;
        for (; j & bit; bit >>= 1) j ^= bit;
        j ^= bit;
        if (i < j) std::swap(a[i], a[j]);
    }

    for (int len = 2; len <= n; len <<= 1) {
        long long wlen = power(root, (mod - 1) / len, mod);
        if (invert) wlen = modInverse(wlen, mod);
        for (int i = 0; i < n; i += len) {
            long long w = 1;
            for (int j = 0; j < len / 2; j++) {
                long long u = a[i + j], v = (a[i + j + len / 2] * w) % mod;
                a[i + j] = (u + v) % mod;
                a[i + j + len / 2] = (u - v + mod) % mod;
                w = (w * wlen) % mod;
            }
        }
    }
    if (invert) {
        long long n_inv = modInverse(n, mod);
        for (long long& x : a) x = (x * n_inv) % mod;
    }
}

bool v_exists[MAX_VAL];
std::vector<int> v_elements;

bool p_base[MAX_SUM + 1];

std::vector<int> u_elements;
bool p_u[MAX_SUM + 1];

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int n;
    long long s;
    std::cin >> n >> s;

    const int BLOCK_SIZE = 2048;
    long long inv_mod1_mod2 = modInverse(MOD1, MOD2);

    for (int i = 0; i < n; i += BLOCK_SIZE) {
        if (!v_elements.empty()) {
            std::vector<long long> p_v1(MAX_FFT_SIZE, 0), p_v2(MAX_FFT_SIZE, 0);
            for (int val : v_elements) {
                p_v1[val] = 1;
                p_v2[val] = 1;
            }

            ntt(p_v1, false, MOD1, ROOT1);
            ntt(p_v2, false, MOD2, ROOT2);

            for (int k = 0; k < MAX_FFT_SIZE; ++k) {
                p_v1[k] = (p_v1[k] * p_v1[k]) % MOD1;
                p_v2[k] = (p_v2[k] * p_v2[k]) % MOD2;
            }

            ntt(p_v1, true, MOD1, ROOT1);
            ntt(p_v2, true, MOD2, ROOT2);

            for (int k = 0; k <= MAX_SUM; ++k) {
                long long c1 = p_v1[k];
                long long c2 = p_v2[k];

                long long k_crt = (c2 - c1 + MOD2) % MOD2;
                k_crt = (k_crt * inv_mod1_mod2) % MOD2;
                long long true_c = c1 + k_crt * MOD1;

                long long term = (k % 2 == 0 && k / 2 < MAX_VAL && v_exists[k / 2]) ? 1 : 0;

                long long true_k = (true_c + term) / 2;
                p_base[k] = (true_k % 2 == 0);
            }
        }
        else {
            std::fill(p_base, p_base + MAX_SUM + 1, true);
        }

        u_elements.clear();
        std::fill(p_u, p_u + MAX_SUM + 1, true);

        int current_block_size = std::min(BLOCK_SIZE, n - i);
        for (int j = 0; j < current_block_size; ++j) {
            s = (s * 618023 + 1) % MAX_VAL;

            bool par_v = p_base[s];
            bool par_u = p_u[s];

            bool par_cross = true;
            for (int u_val : u_elements) {
                long long diff = s - u_val;
                if (diff >= 0 && diff < MAX_VAL && v_exists[diff]) {
                    par_cross = !par_cross;
                }
            }

            bool total_even = (par_v == par_u && par_v == par_cross);

            if (total_even) {
                if (!v_exists[s] && std::find(u_elements.begin(), u_elements.end(), static_cast<int>(s)) == u_elements.end()) {
                    for (int u_old : u_elements) {
                        if (s + u_old <= MAX_SUM) p_u[s + u_old] = !p_u[s + u_old];
                    }
                    if (2 * s <= MAX_SUM) {
                        p_u[2 * s] = !p_u[2 * s];
                    }
                    u_elements.push_back(s);
                }
            }
        }

        for (int u_val : u_elements) {
            if (!v_exists[u_val]) {
                v_exists[u_val] = true;
                v_elements.push_back(u_val);
            }
        }
    }

    std::cout << v_elements.size() << std::endl;

    return 0;
}