def qmin_for_row(r, s):
    # s = n-1, rows r in [-s..s], q in [max(-s, -r-s) .. min(s, -r+s)]
    return max(-s, -r - s)

def qmax_for_row(r, s):
    return min(s, -r + s)

def mat_mul(A, B):
    # 2x2 integer matrices
    return [
        [A[0][0]*B[0][0] + A[0][1]*B[1][0], A[0][0]*B[0][1] + A[0][1]*B[1][1]],
        [A[1][0]*B[0][0] + A[1][1]*B[1][0], A[1][0]*B[0][1] + A[1][1]*B[1][1]],
    ]

def mat_vec(M, q, r):
    return (M[0][0]*q + M[0][1]*r, M[1][0]*q + M[1][1]*r)

def mat_inv(M):
    a, b = M[0]
    c, d = M[1]
    det = a*d - b*c  # here det is ±1
    return [[ d*det, -b*det],
            [-c*det,  a*det]]

def main():
    n = int(input().strip())
    s = n - 1
    rows = []
    for i in range(2*n - 1):
        nums = list(map(int, input().split()))
        # optionally, could assert len==expected
        rows.append(nums)

    ops = input().strip()

    # matrices for single operations
    M_R = [[0, -1], [1, 1]]
    M_L = [[1, 1], [-1, 0]]
    M_T = [[-1, -1], [0, 1]]

    # fold all operations: M = Op_k * ... * Op_2 * Op_1
    M = [[1, 0], [0, 1]]  # identity
    for ch in ops:
        if ch == 'R':
            M = mat_mul(M_R, M)
        elif ch == 'L':
            M = mat_mul(M_L, M)
        else:  # 'T'
            M = mat_mul(M_T, M)

    Minv = mat_inv(M)

    out_lines = []
    # iterate output rows r = -s..s, q from qmin..qmax
    for i_out in range(2*n - 1):
        r_out = i_out - s
        qmin_out = qmin_for_row(r_out, s)
        qmax_out = qmax_for_row(r_out, s)
        line = []
        for q_out in range(qmin_out, qmax_out + 1):
            q0, r0 = mat_vec(Minv, q_out, r_out)
            i0 = r0 + s
            qmin0 = qmin_for_row(r0, s)
            j0 = q0 - qmin0
            line.append(rows[i0][j0])
        out_lines.append(" ".join(map(str, line)))

    print("\n".join(out_lines))

if __name__ == "__main__":
    main()
