#include <iostream>
#include <cmath>
#include <iomanip>

using point = std::pair<int, int>;

double distance(const point& a, const point& b) {
    return std::sqrt(std::pow(a.first - b.first, 2) + std::pow(a.second - b.second, 2));
}

int main() {
    point P1, P2, P3, P4;
    std::cin >> P1.first >> P1.second >> P2.first >> P2.second >> P3.first >> P3.second >> P4.first >> P4.second;
    double S1 = distance(P1, P2);
    double S2 = distance(P2, P3);
    double width = std::min(S1, S2);
    double height = std::max(S1, S2);
    double area = M_PI * (width / 2.0) * (height / 2.0);
    std::cout << std::fixed << std::setprecision(8) << area << '\n';
    return 0;
}